/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.grpc;

public class BalancingSettings {
    private final Policy policy;
    private final String preferableLocation;

    private BalancingSettings(Policy policy) {
        this(policy, null);
    }

    private BalancingSettings(Policy policy, String preferableLocation) {
        this.policy = policy;
        this.preferableLocation = preferableLocation;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public String getPreferableLocation() {
        return this.preferableLocation;
    }

    public static BalancingSettings defaultInstance() {
        return new BalancingSettings(Policy.USE_ALL_NODES);
    }

    public static BalancingSettings fromPolicy(Policy balancingPolicy) {
        return new BalancingSettings(balancingPolicy);
    }

    public static BalancingSettings fromLocation(String preferableLocation) {
        return new BalancingSettings(Policy.USE_PREFERABLE_LOCATION, preferableLocation);
    }

    public static BalancingSettings detectLocalDs() {
        return new BalancingSettings(Policy.USE_DETECT_LOCAL_DC);
    }

    public String toString() {
        return "BalancingSettings{policy=" + (Object)((Object)this.policy) + ", preferableLocation='" + this.preferableLocation + '}';
    }

    public static enum Policy {
        USE_ALL_NODES,
        USE_PREFERABLE_LOCATION,
        USE_DETECT_LOCAL_DC;

    }
}

