/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.auth;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.auth.AuthIdentity;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.core.auth.StaticCredentialsRpc;
import tech.ydb.core.impl.auth.GrpcAuthRpc;
import tech.ydb.proto.auth.YdbAuth;

public class StaticCredentials
implements AuthRpcProvider<GrpcAuthRpc> {
    private static final Logger logger = LoggerFactory.getLogger(StaticCredentials.class);
    private final Clock clock;
    private final YdbAuth.LoginRequest request;

    @VisibleForTesting
    StaticCredentials(Clock clock, String username, String password) {
        this.clock = clock;
        YdbAuth.LoginRequest.Builder builder = YdbAuth.LoginRequest.newBuilder().setUser(username);
        if (password != null) {
            builder.setPassword(password);
        }
        this.request = builder.build();
    }

    public StaticCredentials(String username, String password) {
        this(Clock.systemUTC(), username, password);
    }

    @Override
    public AuthIdentity createAuthIdentity(GrpcAuthRpc rpc) {
        logger.info("create static identity for database {}", (Object)rpc.getDatabase());
        return new IdentityImpl(rpc);
    }

    private class IdentityImpl
    implements AuthIdentity {
        private final AtomicReference<State> state = new AtomicReference<NullState>(new NullState());
        private final StaticCredentialsRpc rpc;

        IdentityImpl(GrpcAuthRpc authRpc) {
            this.rpc = new StaticCredentialsRpc(authRpc, StaticCredentials.this.request, StaticCredentials.this.clock);
        }

        private State updateState(State current, State next) {
            if (this.state.compareAndSet(current, next)) {
                next.init();
            }
            return this.state.get();
        }

        @Override
        public String getToken() {
            return this.state.get().validate(StaticCredentials.this.clock.instant()).token();
        }

        private class ErrorState
        implements State {
            private final RuntimeException ex;

            ErrorState(Throwable ex) {
                this.ex = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException("can't login", ex);
            }

            @Override
            public void init() {
            }

            @Override
            public String token() {
                throw this.ex;
            }

            @Override
            public State validate(Instant instant) {
                return this;
            }
        }

        private class LoggedInState
        implements State {
            private final StaticCredentialsRpc.Token token;

            LoggedInState(StaticCredentialsRpc.Token token) {
                this.token = token;
                logger.debug("logged in with expired at {} and updating at {}", (Object)token.expiredAt(), (Object)token.updateAt());
            }

            @Override
            public void init() {
            }

            @Override
            public String token() {
                return this.token.token();
            }

            @Override
            public State validate(Instant now) {
                if (now.isAfter(this.token.expiredAt())) {
                    return IdentityImpl.this.updateState(this, new SyncLogin()).validate(now);
                }
                if (now.isAfter(this.token.updateAt())) {
                    return IdentityImpl.this.updateState(this, new BackgroundLogin(this.token));
                }
                return this;
            }
        }

        private class BackgroundLogin
        implements State {
            private final StaticCredentialsRpc.Token token;
            private final CompletableFuture<State> future = new CompletableFuture();

            BackgroundLogin(StaticCredentialsRpc.Token token) {
                this.token = token;
            }

            @Override
            public void init() {
                IdentityImpl.this.rpc.loginAsync().whenComplete((nextToken, th) -> {
                    if (nextToken != null) {
                        this.future.complete(new LoggedInState((StaticCredentialsRpc.Token)nextToken));
                    } else {
                        this.future.completeExceptionally((Throwable)th);
                    }
                });
            }

            @Override
            public String token() {
                return this.token.token();
            }

            @Override
            public State validate(Instant now) {
                if (this.future.isCompletedExceptionally()) {
                    if (now.isAfter(this.token.expiredAt())) {
                        return IdentityImpl.this.updateState(this, new SyncLogin()).validate(now);
                    }
                    return IdentityImpl.this.updateState(this, new BackgroundLogin(this.token));
                }
                if (this.future.isDone()) {
                    return IdentityImpl.this.updateState(this, this.future.join());
                }
                return this;
            }
        }

        private class SyncLogin
        implements State {
            private final CompletableFuture<State> future = new CompletableFuture();

            private SyncLogin() {
            }

            @Override
            public void init() {
                IdentityImpl.this.rpc.loginAsync().whenComplete((token, th) -> {
                    if (token != null) {
                        this.future.complete(new LoggedInState((StaticCredentialsRpc.Token)token));
                    } else {
                        this.future.complete(new ErrorState((Throwable)th));
                    }
                });
            }

            @Override
            public String token() {
                throw new IllegalStateException("Get token for unfinished sync state");
            }

            @Override
            public State validate(Instant now) {
                return IdentityImpl.this.updateState(this, IdentityImpl.this.rpc.unwrap(this.future));
            }
        }

        private class NullState
        implements State {
            private NullState() {
            }

            @Override
            public void init() {
            }

            @Override
            public String token() {
                throw new IllegalStateException("Get token for null state");
            }

            @Override
            public State validate(Instant now) {
                return IdentityImpl.this.updateState(this, new SyncLogin()).validate(now);
            }
        }
    }

    private static interface State {
        public void init();

        public State validate(Instant var1);

        public String token();
    }
}

