/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.data.core.dialect;

import java.util.List;
import java.util.function.Function;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.InsertRenderContext;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.TableLike;
import tech.ydb.data.repository.ViewIndex;

public class YdbDialect
extends AbstractDialect {
    public static final YdbDialect INSTANCE = new YdbDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %s OFFSET %s", limit, offset);
        }

        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private static final LockClause LOCK_CLAUSE = new LockClause(){

        public String getLock(LockOptions lockOptions) {
            throw new UnsupportedOperationException("YDB does not support pessimistic locks");
        }

        public LockClause.Position getClausePosition() {
            return null;
        }
    };

    protected Function<Select, CharSequence> getAfterFromTable() {
        return select -> {
            List tables = select.getFrom().getTables();
            if (tables.size() != 1) {
                return "";
            }
            ViewIndex viewIndex = ExposeInvocationInterceptor.currentInvocation().getMethod().getAnnotation(ViewIndex.class);
            if (viewIndex != null && (viewIndex.tableName().isEmpty() || viewIndex.tableName().equals(((TableLike)tables.get(0)).getName().toSql(IdentifierProcessing.NONE)))) {
                return " VIEW " + viewIndex.indexName() + " AS " + ((TableLike)tables.get(0)).getReferenceName().toSql(INSTANCE.getIdentifierProcessing());
            }
            return "";
        };
    }

    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    public LockClause lock() {
        return LOCK_CLAUSE;
    }

    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.create((IdentifierProcessing.Quoting)new IdentifierProcessing.Quoting("`"), (IdentifierProcessing.LetterCasing)IdentifierProcessing.LetterCasing.AS_IS);
    }

    public InsertRenderContext getInsertRenderContext() {
        return () -> {
            throw new UnsupportedOperationException("YDB does not support VALUES (DEFAULT) statement");
        };
    }

    public OrderByNullPrecedence orderByNullHandling() {
        return OrderByNullPrecedence.NONE;
    }
}

