/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.lock.provider;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YdbJDBCLockProvider
implements LockProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(YdbJDBCLockProvider.class);
    private static final String LOCKED_BY = "Hostname=" + Utils.getHostname() + ", Current PID=" + ProcessHandle.current().pid();
    private final DataSource dataSource;

    public YdbJDBCLockProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        try (Connection connection = this.dataSource.getConnection();){
            Optional<SimpleLock> optional;
            ResultSet rs;
            boolean autoCommit;
            block19: {
                Optional<SimpleLock> optional2;
                block20: {
                    autoCommit = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                    PreparedStatement selectPS = connection.prepareStatement("SELECT locked_by, lock_until FROM shedlock WHERE name = ? AND lock_until > CurrentUtcTimestamp()");
                    selectPS.setString(1, lockConfiguration.getName());
                    rs = selectPS.executeQuery();
                    if (!rs.next()) break block19;
                    LOGGER.debug("Instance[{}] acquire lock is failed. Leader is {}, lock_until = {}", new Object[]{LOCKED_BY, rs.getString(1), rs.getString(2)});
                    optional2 = Optional.empty();
                    if (rs == null) break block20;
                    rs.close();
                }
                connection.setAutoCommit(autoCommit);
                return optional2;
            }
            try {
                block21: {
                    if (rs != null) {
                        rs.close();
                    }
                    break block21;
                    {
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                PreparedStatement upsertPS = connection.prepareStatement("UPSERT INTO shedlock(name, lock_until, locked_at, locked_by) VALUES (?, Unwrap(CurrentUtcTimestamp() + ?), CurrentUtcTimestamp(), ?)");
                upsertPS.setObject(1, lockConfiguration.getName());
                upsertPS.setObject(2, lockConfiguration.getLockAtMostFor());
                upsertPS.setObject(3, LOCKED_BY);
                upsertPS.execute();
                connection.commit();
                LOGGER.debug("Instance[{}] is leader", (Object)LOCKED_BY);
                optional = Optional.of(new YdbJDBCLock(lockConfiguration.getName(), this.dataSource));
            }
            catch (Throwable throwable) {
                connection.setAutoCommit(autoCommit);
                throw throwable;
            }
            connection.setAutoCommit(autoCommit);
            return optional;
        }
        catch (SQLException e) {
            LOGGER.debug("Instance[{}] acquire lock is failed", (Object)LOCKED_BY);
            return Optional.empty();
        }
    }

    private record YdbJDBCLock(String name, DataSource dataSource) implements SimpleLock
    {
        private static final int ATTEMPT_RELEASE_LOCK = 10;

        public void unlock() {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.doUnlock();
                    return;
                }
                catch (SQLException e) {
                    if (i != 9) continue;
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUnlock() throws SQLException {
            try (Connection connection = this.dataSource.getConnection();){
                boolean autoCommit = connection.getAutoCommit();
                try {
                    connection.setAutoCommit(true);
                    PreparedStatement ps = connection.prepareStatement("UPDATE shedlock SET lock_until = CurrentUtcTimestamp() WHERE name = ? and locked_by = ?");
                    ps.setString(1, this.name);
                    ps.setString(2, LOCKED_BY);
                    ps.execute();
                }
                finally {
                    connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                LOGGER.debug(String.format("Instance[{%s}] release lock is failed", LOCKED_BY), (Throwable)e);
                throw e;
            }
        }
    }
}

