/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropIndexGenerator;
import liquibase.statement.core.DropIndexStatement;
import liquibase.structure.DatabaseObject;
import tech.ydb.liquibase.database.YdbDatabase;

public class DropIndexGeneratorYdb
extends DropIndexGenerator {
    public boolean supports(DropIndexStatement statement, Database database) {
        return database instanceof YdbDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(DropIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = super.validate(statement, database, sqlGeneratorChain);
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        return validationErrors;
    }

    public Sql[] generateSql(DropIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName()) + " DROP INDEX " + database.escapeIndexName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getIndexName()), new DatabaseObject[]{this.getAffectedIndex(statement)})};
    }
}

