/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.sqlgenerator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import liquibase.change.AddColumnConfig;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateIndexGenerator;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;
import tech.ydb.liquibase.database.YdbDatabase;

public class CreateIndexGeneratorYdb
extends CreateIndexGenerator {
    public boolean supports(CreateIndexStatement statement, Database database) {
        return database instanceof YdbDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(CreateIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        List associatedWith = StringUtil.splitAndTrim((String)statement.getAssociatedWith(), (String)",");
        if (associatedWith != null && (associatedWith.contains("primaryKey") || associatedWith.contains("uniqueConstraint"))) {
            return EMPTY_SQL;
        }
        StringBuilder yqlCreateIndex = new StringBuilder();
        yqlCreateIndex.append("ALTER TABLE ").append(database.escapeTableName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName())).append(" ADD INDEX ").append(database.escapeIndexName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getIndexName())).append(" GLOBAL ON (");
        Iterator<AddColumnConfig> iterator = Arrays.asList(statement.getColumns()).iterator();
        while (iterator.hasNext()) {
            AddColumnConfig column = iterator.next();
            yqlCreateIndex.append(database.escapeColumnName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName(), column.getName()));
            if (!iterator.hasNext()) continue;
            yqlCreateIndex.append(", ");
        }
        yqlCreateIndex.append(")");
        return new Sql[]{new UnparsedSql(yqlCreateIndex.toString(), new DatabaseObject[]{this.getAffectedIndex(statement)})};
    }

    public ValidationErrors validate(CreateIndexStatement createIndexStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors errors = super.validate(createIndexStatement, database, sqlGeneratorChain);
        errors.checkRequiredField("name", (Object)createIndexStatement.getIndexName());
        if (createIndexStatement.isUnique() != null && createIndexStatement.isUnique().booleanValue()) {
            errors.addError("YDB doesn't support UNIQUE CONSTRAINT! [table name = " + createIndexStatement.getTableName() + ", index name = " + createIndexStatement.getIndexName() + "]");
        }
        for (AddColumnConfig column : createIndexStatement.getColumns()) {
            if (column.getDescending() != null && column.getDescending().booleanValue()) {
                errors.addError("YDB doesn't support descending column in index! " + CreateIndexGeneratorYdb.badColumnStrPointer(createIndexStatement, column));
            }
            if (column.getComputed() == null || !column.getComputed().booleanValue()) continue;
            errors.addError("YDB doesn't support computed column in index! " + CreateIndexGeneratorYdb.badColumnStrPointer(createIndexStatement, column));
        }
        return errors;
    }

    private static String badColumnStrPointer(CreateIndexStatement createIndexStatement, AddColumnConfig column) {
        return "[table name = " + createIndexStatement.getTableName() + ", index name = " + createIndexStatement.getIndexName() + ", column name = " + column.getName() + "]";
    }
}

