/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.type;

import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import tech.ydb.liquibase.type.BaseTypeYdb;

@DataTypeInfo(name="Decimal", aliases={"decimal, java.sql.Types.DECIMAL", "java.math.BigDecimal"}, minParameters=2, maxParameters=2, priority=5)
public class DecimalTypeYdb
extends BaseTypeYdb {
    public boolean validate(Database database) {
        return super.validate(database) && this.getParameters()[0].equals(22) && this.getParameters()[1].equals(9);
    }

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        return new DatabaseDataType(this.getRawDefinition().toUpperCase());
    }

    public LoadDataChange.LOAD_DATA_TYPE getLoadTypeName() {
        return LoadDataChange.LOAD_DATA_TYPE.NUMERIC;
    }

    public String objectToSql(Object value, Database database) {
        if (value == null || "null".equalsIgnoreCase(value.toString())) {
            return "NULL";
        }
        return "CAST('" + value + "' AS DECIMAL(22,9))";
    }
}

