/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.core.AddColumnStatement;
import tech.ydb.liquibase.database.YdbDatabase;
import tech.ydb.liquibase.exception.YdbMessageException;

public class AddColumnGeneratorYdb
extends AddColumnGenerator {
    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof YdbDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(AddColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = super.validate(statement, database, sqlGeneratorChain);
        if (statement.isMultiple()) {
            for (AddColumnStatement addColumnStatement : statement.getColumns()) {
                AddColumnGeneratorYdb.checkAddColumnStatement(validationErrors, addColumnStatement);
            }
        } else {
            AddColumnGeneratorYdb.checkAddColumnStatement(validationErrors, statement);
        }
        return validationErrors;
    }

    private static void checkAddColumnStatement(ValidationErrors validationErrors, AddColumnStatement statement) {
        if (statement.isUnique()) {
            validationErrors.addError("YDB doesn't support UNIQUE CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((AddColumnStatement)statement).getTableName()));
        }
        if (!statement.isNullable()) {
            validationErrors.addError("YDB doesn't support NOT NULL CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((AddColumnStatement)statement).getTableName()));
        }
        if (statement.isAutoIncrement()) {
            validationErrors.addError("YDB doesn't support AUTO INCREMENT CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((AddColumnStatement)statement).getTableName()));
        }
        if (statement.isPrimaryKey()) {
            validationErrors.addError("YDB doesn't support PRIMARY KEY it was created by CREATE TABLE! " + YdbMessageException.badTableStrPointer(() -> ((AddColumnStatement)statement).getTableName()));
        }
        if (statement.getDefaultValue() != null) {
            validationErrors.addError("YDB doesn't support DEFAULT VALUE CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((AddColumnStatement)statement).getTableName()));
        }
    }
}

