/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.sqlgenerator;

import java.util.Iterator;
import java.util.function.Function;
import liquibase.database.Database;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertOrUpdateGenerator;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.structure.DatabaseObject;
import tech.ydb.liquibase.database.YdbDatabase;

public class InsertOrUpdateGeneratorYdb
extends InsertOrUpdateGenerator {
    public boolean supports(InsertOrUpdateStatement statement, Database database) {
        return database instanceof YdbDatabase;
    }

    public Sql[] generateSql(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder yqlUpsert = new StringBuilder();
        yqlUpsert.append("UPSERT INTO ").append(database.escapeTableName(insertOrUpdateStatement.getCatalogName(), insertOrUpdateStatement.getSchemaName(), insertOrUpdateStatement.getTableName())).append(" (");
        InsertOrUpdateGeneratorYdb.sequenceParams(insertOrUpdateStatement, yqlUpsert, Function.identity());
        yqlUpsert.append(") VALUES (");
        InsertOrUpdateGeneratorYdb.sequenceParams(insertOrUpdateStatement, yqlUpsert, columnName -> insertOrUpdateStatement.getColumnValues().get(columnName).toString());
        yqlUpsert.append(")");
        return new Sql[]{new UnparsedSql(yqlUpsert.toString(), new DatabaseObject[]{this.getAffectedTable(insertOrUpdateStatement)})};
    }

    private static void sequenceParams(InsertOrUpdateStatement insertOrUpdateStatement, StringBuilder yqlUpsert, Function<String, String> mapColumnName) {
        Iterator columnNameIterator = insertOrUpdateStatement.getColumnValues().keySet().iterator();
        while (columnNameIterator.hasNext()) {
            yqlUpsert.append(mapColumnName.apply((String)columnNameIterator.next()));
            if (!columnNameIterator.hasNext()) continue;
            yqlUpsert.append(", ");
        }
    }

    protected String getRecordCheck(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause) {
        return "";
    }

    protected String getElse(Database database) {
        return "";
    }
}

