/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.change;

import java.io.IOException;
import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.util.csv.CSVReader;
import tech.ydb.liquibase.change.LoadDataChangeYdb;

@DatabaseChange(name="loadUpdateData", description="Loads or updates data from a CSV file into an existing table. Differs from loadData by issuing a SQL batch that checks for the existence of a record. If found, the record is UPDATEd, else the record is INSERTed. Also, generates DELETE statements for a rollback.\n\nA value of NULL in a cell will be converted to a database NULL rather than the string 'NULL'", priority=5, appliesTo={"table"}, since="2.0")
public class LoadUpdateDataChangeYdb
extends LoadDataChangeYdb {
    protected boolean hasPreparedStatementsImplemented() {
        return false;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return super.generateStatements(database);
    }

    @Override
    protected SqlStatement[] getSqlStatements(Database database, CSVReader reader, String[] headers) throws IOException {
        String[] line;
        ArrayList<InsertOrUpdateStatement> sqlStatements = new ArrayList<InsertOrUpdateStatement>();
        while ((line = reader.readNext()) != null) {
            InsertOrUpdateStatement insertStatement = new InsertOrUpdateStatement(this.catalogName, this.schemaName, this.tableName, "");
            for (int i = 0; i < line.length; ++i) {
                String columnName = headers[i];
                insertStatement.addColumnValue(columnName, (Object)this.columnToLiquibaseDataType.getOrDefault(columnName, DataTypeFactory.getInstance().fromDescription("text", database)).objectToSql((Object)line[i], database));
            }
            sqlStatements.add(insertStatement);
        }
        return sqlStatements.toArray(new SqlStatement[0]);
    }
}

