/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.change;

import com.opencsv.exceptions.CsvMalformedLineException;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.change.DatabaseChange;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.csv.CSVReader;
import tech.ydb.liquibase.database.YdbDatabase;

@DatabaseChange(name="loadData", description="Loads data from a CSV file into an existing table", priority=5, appliesTo={"table"}, since="1.7")
public class LoadDataChangeYdb
extends LoadDataChange {
    private static final Logger LOG = Scope.getCurrentScope().getLog(LoadDataChange.class);
    protected final Map<String, LiquibaseDataType> columnToLiquibaseDataType = new LinkedHashMap<String, LiquibaseDataType>();

    public boolean supports(Database database) {
        return database instanceof YdbDatabase;
    }

    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] sqlStatementArray;
        block14: {
            CSVReader reader = this.getCSVReader();
            try {
                if (reader == null) {
                    throw new UnexpectedLiquibaseException("Unable to read file " + this.getFile());
                }
                String[] headers = reader.readNext();
                if (headers == null) {
                    throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was empty");
                }
                JdbcConnection jdbcConnection = (JdbcConnection)database.getConnection();
                ResultSet resultSet = jdbcConnection.getMetaData().getColumns(null, null, this.tableName, null);
                while (resultSet.next()) {
                    this.columnToLiquibaseDataType.put(resultSet.getString("COLUMN_NAME").toLowerCase(), DataTypeFactory.getInstance().fromDescription(resultSet.getString("TYPE_NAME"), database));
                }
                sqlStatementArray = this.getSqlStatements(database, reader, headers);
                if (reader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CsvMalformedLineException e) {
                    throw new RuntimeException("Error parsing " + this.getRelativeTo() + " on line " + e.getLineNumber() + ": " + e.getMessage());
                }
                catch (UnexpectedLiquibaseException ule) {
                    if (this.getChangeSet() != null && this.getChangeSet().getFailOnError() != null && !this.getChangeSet().getFailOnError().booleanValue()) {
                        LOG.info("Changeset " + this.getChangeSet().toString(false) + " failed, but failOnError was false.  Error: " + ule.getMessage());
                        return SqlStatement.EMPTY_SQL_STATEMENT;
                    }
                    throw ule;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
        }
        return sqlStatementArray;
    }

    protected SqlStatement[] getSqlStatements(Database database, CSVReader reader, String[] headers) throws IOException {
        String[] line;
        StringBuilder yqlInsert = new StringBuilder();
        yqlInsert.append("INSERT INTO ").append(database.escapeTableName(this.getCatalogName(), this.getSchemaName(), this.tableName)).append(" (");
        Iterator iteratorColumnNames = Arrays.stream(headers).iterator();
        while (iteratorColumnNames.hasNext()) {
            yqlInsert.append((String)iteratorColumnNames.next());
            if (!iteratorColumnNames.hasNext()) continue;
            yqlInsert.append(", ");
        }
        yqlInsert.append(") VALUES (");
        boolean havePrev = false;
        while ((line = reader.readNext()) != null) {
            if (havePrev) {
                yqlInsert.append("), (");
            }
            for (int i = 0; i < line.length; ++i) {
                String columnName = headers[i];
                yqlInsert.append(this.columnToLiquibaseDataType.getOrDefault(columnName, DataTypeFactory.getInstance().fromDescription("text", database)).objectToSql((Object)line[i], database));
                if (i >= line.length - 1) continue;
                yqlInsert.append(", ");
            }
            havePrev = true;
        }
        yqlInsert.append(")");
        return new SqlStatement[]{new RawSqlStatement(yqlInsert.toString())};
    }

    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return super.createStatement(catalogName, schemaName, tableName);
    }
}

