/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.flywaydb.database;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import java.util.UUID;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import tech.ydb.flywaydb.database.YdbDatabase;
import tech.ydb.flywaydb.database.YdbSchema;

public class YdbTable
extends Table<YdbDatabase, YdbSchema> {
    private static final Duration WAIT_LOCK_TIMEOUT = Duration.ofMinutes(2L);
    private static final int RELEASE_MAX_ATTEMPT = 10;
    private final String tableLockId = UUID.randomUUID() + "-flyway-lock-id";
    private final Random random = new Random();

    public YdbTable(JdbcTemplate jdbcTemplate, YdbDatabase database, YdbSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected boolean doExists() throws SQLException {
        return this.exists(null, this.schema, this.name, new String[0]);
    }

    protected void doLock() {
        if (this.lockDepth > 0) {
            return;
        }
        Instant startLock = Instant.now();
        do {
            if (this.insertLockingRow()) {
                return;
            }
            try {
                Thread.sleep(100 + this.random.nextInt(1000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (startLock.isAfter(Instant.now().minus(WAIT_LOCK_TIMEOUT)));
        throw new FlywayException("Unable to obtain table lock - another Flyway instance may be running");
    }

    protected void doUnlock() {
        if (this.lockDepth > 1) {
            return;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            SQLException sqlException = this.jdbcTemplate.executeStatement("DELETE FROM " + this + " WHERE installed_rank = -100 AND version = '" + this.tableLockId + "'").getException();
            if (sqlException == null) {
                return;
            }
            if (attempt != 9) continue;
            throw new FlywayException((Throwable)sqlException);
        }
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((YdbDatabase)this.database).doQuote(this.name), new Object[0]);
    }

    private boolean insertLockingRow() {
        Results results = this.jdbcTemplate.executeStatement("INSERT INTO " + this + "(installed_rank, version, description, type, script, checksum, installed_by, execution_time, success, installed_on) VALUES (-100, '" + this.tableLockId + "', 'flyway-lock', '', '', 0, '', 0, TRUE, CurrentUtcDatetime())");
        try {
            this.jdbcTemplate.getConnection().commit();
            return results.getException() == null;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public String toString() {
        return ((YdbDatabase)this.database).doQuote(this.name);
    }
}

