/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.flywaydb.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import tech.ydb.flywaydb.database.YdbDatabase;
import tech.ydb.flywaydb.database.YdbTable;

public class YdbSchema
extends Schema<YdbDatabase, YdbTable> {
    public YdbSchema(JdbcTemplate jdbcTemplate, YdbDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() {
        return true;
    }

    protected boolean doEmpty() throws SQLException {
        return this.doAllTables().length == 0;
    }

    protected void doCreate() {
    }

    protected void doDrop() {
    }

    protected void doClean() throws SQLException {
        List<String> schemaTables = this.schemaTables();
        if (schemaTables.isEmpty()) {
            return;
        }
        this.jdbcTemplate.executeStatement(schemaTables.stream().map(table -> "DROP TABLE " + table).collect(Collectors.joining("; ")));
    }

    protected YdbTable[] doAllTables() throws SQLException {
        return (YdbTable[])this.schemaTables().stream().map(table -> new YdbTable(this.jdbcTemplate, (YdbDatabase)this.database, this, this.name)).toArray(YdbTable[]::new);
    }

    public YdbTable getTable(String tableName) {
        return new YdbTable(this.jdbcTemplate, (YdbDatabase)this.database, this, tableName);
    }

    public String toString() {
        return "ydb_schema";
    }

    private List<String> schemaTables() throws SQLException {
        ResultSet rs = this.jdbcTemplate.getConnection().getMetaData().getTables(null, this.name, null, new String[]{"TABLE"});
        ArrayList<String> tables = new ArrayList<String>();
        while (rs.next()) {
            tables.add(((YdbDatabase)this.database).quote(new String[]{rs.getString("TABLE_NAME")}));
        }
        return tables;
    }
}

