/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.flywaydb.database;

import java.sql.Connection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import tech.ydb.flywaydb.database.YdbConnection;
import tech.ydb.flywaydb.database.YdbDatabase;
import tech.ydb.flywaydb.database.YdbParser;

public class YdbDatabaseType
extends BaseDatabaseType {
    private static final String YDB_NAME = "YDB";
    private static final String DRIVER_NAME = "tech.ydb.jdbc.YdbDriver";

    public String getName() {
        return YDB_NAME;
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:ydb:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return DRIVER_NAME;
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith(YDB_NAME);
    }

    public Database<YdbConnection> createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new YdbDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new YdbParser(configuration, parsingContext);
    }
}

