/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.flywaydb.database;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import tech.ydb.flywaydb.database.YdbConnection;

public class YdbDatabase
extends Database<YdbConnection> {
    public YdbDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected YdbConnection doGetConnection(Connection connection) {
        return new YdbConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + this.doQuote(table.getName()) + " (\n    installed_rank INT32 NOT NULL,\n    version TEXT,\n    description TEXT,\n    type TEXT,\n    script TEXT,\n    checksum INT32,\n    installed_by TEXT,\n    installed_on DATETIME,\n    execution_time INT32,\n    success BOOL,\n    PRIMARY KEY (installed_rank));\n" + (baseline ? this.getBaselineStatement(table) : "");
    }

    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote(new String[]{"installed_rank"}) + "," + this.quote(new String[]{"version"}) + "," + this.quote(new String[]{"description"}) + "," + this.quote(new String[]{"type"}) + "," + this.quote(new String[]{"script"}) + "," + this.quote(new String[]{"checksum"}) + "," + this.quote(new String[]{"installed_on"}) + "," + this.quote(new String[]{"installed_by"}) + "," + this.quote(new String[]{"execution_time"}) + "," + this.quote(new String[]{"success"}) + " FROM " + this.quote(new String[]{table.getName()}) + " WHERE " + this.quote(new String[]{"installed_rank"}) + " > ? ORDER BY " + this.quote(new String[]{"installed_rank"});
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + this.quote(new String[]{table.getName()}) + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ", " + this.quote(new String[]{"installed_on"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, CurrentUtcDatetime())";
    }

    protected String getOpenQuote() {
        return "`";
    }

    protected String getCloseQuote() {
        return "`";
    }

    protected String getEscapedQuote() {
        return "\\";
    }
}

