/*
 * Decompiled with CFR 0.152.
 */
package tech.yanand.flyingmybatis;

import java.lang.reflect.Field;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import tech.yanand.flyingmybatis.MetaDataCache;
import tech.yanand.flyingmybatis.PrimaryKey;
import tech.yanand.flyingmybatis.TableInfo;

class MybatisHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MybatisHelper.class);

    private MybatisHelper() {
    }

    static void setMappedStatementKeys(Configuration configuration, Class<?> mapperInterface, String methodName) {
        MappedStatement mappedStatement = configuration.getMappedStatement(mapperInterface.getName() + methodName);
        LOG.info("Set key information for MappedStatement: [{}]", (Object)mappedStatement.getId());
        TableInfo tableInfo = MetaDataCache.getTableInfo(mapperInterface);
        String[] keyProperties = new String[]{tableInfo.getPrimaryKeyField()};
        String[] keyColumns = new String[]{tableInfo.getPrimaryKey()};
        MybatisHelper.setFieldValue(mappedStatement, "keyProperties", keyProperties);
        MybatisHelper.setFieldValue(mappedStatement, "keyColumns", keyColumns);
        if (tableInfo.getKeyType() == PrimaryKey.KeyType.AUTO) {
            MybatisHelper.setFieldValue(mappedStatement, "keyGenerator", Jdbc3KeyGenerator.INSTANCE);
        }
    }

    static void setFieldValue(Object entity, String fieldName, Object fieldValue) {
        Field field = ReflectionUtils.findField(entity.getClass(), (String)fieldName);
        if (field == null) {
            throw new IllegalStateException("Could not set field [" + fieldName + "].");
        }
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)entity, (Object)fieldValue);
    }

    static Object getFieldValue(Object entity, String fieldName) {
        Field field = ReflectionUtils.findField(entity.getClass(), (String)fieldName);
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            return ReflectionUtils.getField((Field)field, (Object)entity);
        }
        throw new IllegalStateException("Could not get field [" + fieldName + "].");
    }
}

