/*
 * Decompiled with CFR 0.152.
 */
package tech.yanand.flyingmybatis;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.yanand.flyingmybatis.CaseFormatUtils;
import tech.yanand.flyingmybatis.Column;
import tech.yanand.flyingmybatis.ColumnInfo;
import tech.yanand.flyingmybatis.PrimaryKey;
import tech.yanand.flyingmybatis.Table;
import tech.yanand.flyingmybatis.TableInfo;

final class MetaDataCache {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataCache.class);
    private static final ConcurrentMap<Class<?>, TableInfo> DATA_CACHE = new ConcurrentHashMap();
    static final String ENTITY_PLACEHOLDER = "@EP@";

    private MetaDataCache() {
    }

    static TableInfo getTableInfo(Class<?> mapperType) {
        return DATA_CACHE.computeIfAbsent(mapperType, MetaDataCache::getTableInfoFromType);
    }

    private static TableInfo getTableInfoFromType(Class<?> mapperType) {
        Field[] fields;
        Class<?> beanClass = MetaDataCache.getBeanType(mapperType);
        TableInfo tableInfo = new TableInfo();
        tableInfo.setDomainName(beanClass.getTypeName());
        LOG.info("Resolved Bean from mapper namespace: [{}]", (Object)beanClass.getTypeName());
        Table table = beanClass.getDeclaredAnnotation(Table.class);
        tableInfo.setTableName(Objects.isNull(table) ? CaseFormatUtils.toTableName(beanClass.getSimpleName()) : table.value());
        ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
        ArrayList<String> baseColumns = new ArrayList<String>();
        ArrayList<String> intoValues = new ArrayList<String>();
        for (Field field : fields = beanClass.getDeclaredFields()) {
            PrimaryKey primaryKey;
            Column column = field.getDeclaredAnnotation(Column.class);
            ColumnInfo columnInfo = new ColumnInfo();
            if (Objects.nonNull(column)) {
                columnInfo.setFieldName(field.getName());
                String columnName = column.value();
                columnInfo.setColumnName(columnName.isEmpty() ? CaseFormatUtils.toColumnName(field.getName()) : columnName);
                columnInfo.setString(field.getType().isAssignableFrom(String.class));
                baseColumns.add(columnInfo.getColumnName());
                intoValues.add(String.format("#{%s.%s}", ENTITY_PLACEHOLDER, columnInfo.getFieldName()));
                columnInfos.add(columnInfo);
            }
            if (!Objects.nonNull(primaryKey = field.getDeclaredAnnotation(PrimaryKey.class))) continue;
            if (Objects.isNull(column)) {
                throw new IllegalStateException("Primary key [" + field.getName() + "] must be a column.");
            }
            tableInfo.setPrimaryKey(columnInfo.getColumnName());
            tableInfo.setPrimaryKeyField(columnInfo.getFieldName());
            tableInfo.setKeyType(primaryKey.keyType());
        }
        if (Objects.isNull(tableInfo.getPrimaryKey())) {
            throw new IllegalStateException("Table [" + tableInfo.getTableName() + "] must has a primary key.");
        }
        if (tableInfo.getKeyType() == PrimaryKey.KeyType.AUTO) {
            baseColumns.remove(tableInfo.getPrimaryKey());
            intoValues.remove(String.format("#{%s.%s}", ENTITY_PLACEHOLDER, tableInfo.getPrimaryKeyField()));
        }
        tableInfo.setBaseColumns(String.join((CharSequence)", ", baseColumns));
        tableInfo.setIntoValues(String.join((CharSequence)", ", intoValues));
        tableInfo.setColumnInfos(columnInfos);
        return tableInfo;
    }

    private static Class<?> getBeanType(Class<?> mapperType) {
        Type[] genericInterfaces = mapperType.getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)genericInterfaces[0];
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }
}

