/*
 * Decompiled with CFR 0.152.
 */
package tech.yanand.flyingmybatis;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;
import org.apache.ibatis.jdbc.SQL;
import tech.yanand.flyingmybatis.ColumnInfo;
import tech.yanand.flyingmybatis.MetaDataCache;
import tech.yanand.flyingmybatis.MybatisHelper;
import tech.yanand.flyingmybatis.PrimaryKey;
import tech.yanand.flyingmybatis.TableInfo;

public class AutoMapperProvider
implements ProviderMethodResolver {
    private static final String WHERE_COLUMN_EQUALS = "%s = #{%s}";
    private static final String WHERE_ID_IN = "%s in (%s)";
    private static final String SET_COLUMN = "%s = #{entity.%s}";
    private static final String TRUNCATE_TABLE = "truncate table %s";
    private static final String ENTITY = "entity";
    private static final String ENTITY_IS_NULL = "Entity is null";

    public static <E> String insert(@Param(value="entity") E entity, ProviderContext context) {
        entity = AutoMapperProvider.getParam(entity, ENTITY);
        Objects.requireNonNull(entity, ENTITY_IS_NULL);
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        if (tableInfo.getKeyType() == PrimaryKey.KeyType.UUID) {
            MybatisHelper.setFieldValue(entity, tableInfo.getPrimaryKeyField(), UUID.randomUUID().toString());
        }
        return ((SQL)((SQL)((SQL)new SQL().INSERT_INTO(tableInfo.getTableName())).INTO_COLUMNS(new String[]{tableInfo.getBaseColumns()})).INTO_VALUES(new String[]{tableInfo.getIntoValues().replace("@EP@", ENTITY)})).toString();
    }

    public static <E> String insertAll(@Param(value="entities") Collection<E> entities, ProviderContext context) {
        AutoMapperProvider.checkArgument(entities, "Entities is null or empty");
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        if (tableInfo.getKeyType() == PrimaryKey.KeyType.UUID) {
            entities.forEach(entity -> MybatisHelper.setFieldValue(entity, tableInfo.getPrimaryKeyField(), UUID.randomUUID().toString()));
        }
        return ((SQL)((SQL)((SQL)new SQL().INSERT_INTO(tableInfo.getTableName())).INTO_COLUMNS(new String[]{tableInfo.getBaseColumns()})).applyForEach(entities, (sql, entity, index) -> ((SQL)sql.INTO_VALUES(new String[]{tableInfo.getIntoValues().replace("@EP@", "entities[" + index + "]")})).ADD_ROW())).toString();
    }

    public static <K> String selectById(@Param(value="id") K id, ProviderContext context) {
        id = AutoMapperProvider.getParam(id, "id");
        Objects.requireNonNull(id, "ID is null");
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)((SQL)new SQL().SELECT("*")).FROM(tableInfo.getTableName())).WHERE(String.format(WHERE_COLUMN_EQUALS, tableInfo.getPrimaryKey(), "id"))).toString();
    }

    public static <K> String selectAllById(@Param(value="ids") Collection<K> ids, ProviderContext context) {
        AutoMapperProvider.checkArgument(ids, "IDs is null or empty");
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)((SQL)new SQL().SELECT("*")).FROM(tableInfo.getTableName())).WHERE(String.format(WHERE_ID_IN, tableInfo.getPrimaryKey(), AutoMapperProvider.getIdIn(ids)))).toString();
    }

    public static String selectAllByColumn(@Param(value="column") String column, @Param(value="value") Object value, ProviderContext context) {
        Objects.requireNonNull(value);
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)((SQL)new SQL().SELECT("*")).FROM(tableInfo.getTableName())).WHERE(String.format(WHERE_COLUMN_EQUALS, column, "value"))).toString();
    }

    public static String selectAll(ProviderContext context) {
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)new SQL().SELECT("*")).FROM(tableInfo.getTableName())).toString();
    }

    public static String countAll(ProviderContext context) {
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)new SQL().SELECT("count(*)")).FROM(tableInfo.getTableName())).toString();
    }

    public static <K> String deleteById(@Param(value="id") K id, ProviderContext context) {
        id = AutoMapperProvider.getParam(id, "id");
        Objects.requireNonNull(id, "ID is null");
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)new SQL().DELETE_FROM(tableInfo.getTableName())).WHERE(String.format(WHERE_COLUMN_EQUALS, tableInfo.getPrimaryKey(), "id"))).toString();
    }

    public static <K> String deleteAllById(@Param(value="ids") Collection<K> ids, ProviderContext context) {
        AutoMapperProvider.checkArgument(ids, "IDs is null or empty");
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return ((SQL)((SQL)new SQL().DELETE_FROM(tableInfo.getTableName())).WHERE(String.format(WHERE_ID_IN, tableInfo.getPrimaryKey(), AutoMapperProvider.getIdIn(ids)))).toString();
    }

    public static String deleteAll(ProviderContext context) {
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return String.format(TRUNCATE_TABLE, tableInfo.getTableName());
    }

    public static <E> String update(@Param(value="entity") E entity, ProviderContext context) {
        entity = AutoMapperProvider.getParam(entity, ENTITY);
        Objects.requireNonNull(entity, ENTITY_IS_NULL);
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        return AutoMapperProvider.buildUpdateSql(tableInfo, columnInfo -> true);
    }

    public static <E> String updateSelective(@Param(value="entity") E entity, ProviderContext context) {
        Object finalEntity = AutoMapperProvider.getParam(entity, ENTITY);
        TableInfo tableInfo = MetaDataCache.getTableInfo(context.getMapperType());
        Objects.requireNonNull(finalEntity, ENTITY_IS_NULL);
        Objects.requireNonNull(MybatisHelper.getFieldValue(finalEntity, tableInfo.getPrimaryKeyField()), "Updated entity ID is null");
        return AutoMapperProvider.buildUpdateSql(tableInfo, columnInfo -> Objects.nonNull(MybatisHelper.getFieldValue(finalEntity, columnInfo.getFieldName())));
    }

    private static String buildUpdateSql(TableInfo tableInfo, Predicate<ColumnInfo> selective) {
        SQL sql = (SQL)new SQL().UPDATE(tableInfo.getTableName());
        for (ColumnInfo columnInfo : tableInfo.getColumnInfos()) {
            if (!selective.test(columnInfo)) continue;
            sql.SET(String.format(SET_COLUMN, columnInfo.getColumnName(), columnInfo.getFieldName()));
        }
        sql.WHERE(String.format(WHERE_COLUMN_EQUALS, tableInfo.getPrimaryKey(), "entity." + tableInfo.getPrimaryKeyField()));
        return sql.toString();
    }

    private static <K> String getIdIn(Collection<K> ids) {
        return IntStream.range(0, ids.size()).mapToObj(index -> "#{ids[" + index + "]}").collect(Collectors.joining(", "));
    }

    private static <T> T getParam(Object paramMap, String key) {
        return (T)((Map)paramMap).get(key);
    }

    private static <T> void checkArgument(Collection<T> arg, String message) {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }
}

