/*
 * Decompiled with CFR 0.152.
 */
package tech.yanand.flyingmybatis;

import java.util.Arrays;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import tech.yanand.flyingmybatis.AutoMapper;
import tech.yanand.flyingmybatis.MybatisHelper;

public class AutoMapperProcessor
implements BeanPostProcessor {
    private static final String INSERT = ".insert";
    private static final String INSERT_ALL = ".insertAll";

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MapperFactoryBean) {
            MapperFactoryBean factoryBean = (MapperFactoryBean)bean;
            this.modifyKeyInfo(factoryBean, INSERT);
            this.modifyKeyInfo(factoryBean, INSERT_ALL);
        }
        return bean;
    }

    private void modifyKeyInfo(MapperFactoryBean<?> factoryBean, String methodName) {
        Class mapperInterface = factoryBean.getMapperInterface();
        if (this.isAutoMapperBased(mapperInterface)) {
            MybatisHelper.setMappedStatementKeys(factoryBean.getSqlSession().getConfiguration(), mapperInterface, methodName);
        }
    }

    private boolean isAutoMapperBased(Class<?> mapperInterface) {
        return Arrays.stream(mapperInterface.getInterfaces()).anyMatch(AutoMapper.class::equals);
    }
}

