package tech.yanand.flyingmybatis;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks the field of the class as the primary key field.
 *
 * @author Richard Zhang
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface PrimaryKey {

    /**
     * Configuring the primary key is auto-increment, UUID or input.
     *
     * @return Key type.
     */
    KeyType keyType() default KeyType.AUTO;

    /**
     * The type of primary key.
     *
     * @author Richard Zhang
     */
    enum KeyType {

        /**
         * Auto-increment by DB.
         */
        AUTO,

        /**
         * Generated by Java {@link java.util.UUID}
         */
        UUID,

        /**
         * Custom input key.
         */
        INPUT
    }
}
