/*
 * Decompiled with CFR 0.152.
 */
package tech.yanand.flyingcache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import tech.yanand.flyingcache.CallableWrapper;
import tech.yanand.flyingcache.RunnableWrapper;

abstract class AbstractCacheManager
implements CacheManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<ConcurrentMap<String, Cache>> threadCacheHolder = new NamedThreadLocal("Thread caches");

    AbstractCacheManager() {
    }

    public static void clearThreadCache() {
        threadCacheHolder.remove();
    }

    public Cache getCache(String name) {
        ConcurrentMap<String, Cache> caches;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            ConcurrentMap<String, Cache> caches2 = this.getCacheFromRequest(requestAttributes);
            if (caches2 == null) {
                caches2 = new ConcurrentHashMap<String, Cache>();
                requestAttributes.setAttribute(this.getCacheKey(), caches2, this.getScope());
            }
            return caches2.computeIfAbsent(name, ConcurrentMapCache::new);
        }
        if (this.logger.isWarnEnabled() && !this.isCallingInWrapper()) {
            this.logger.warn("The current thread is not in a request scope, so it will utilize ThreadLocal cache data. It is important to note that at the end of the thread, clearCache() should be called to prevent memory leaks. Or using RunnableWrapper or CallableWrapper to wrap the task of the thread.");
        }
        if ((caches = threadCacheHolder.get()) == null) {
            caches = new ConcurrentHashMap<String, Cache>();
            threadCacheHolder.set(caches);
        }
        return caches.computeIfAbsent(name, ConcurrentMapCache::new);
    }

    public Collection<String> getCacheNames() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ConcurrentMap<String, Cache> caches = requestAttributes != null ? this.getCacheFromRequest(requestAttributes) : threadCacheHolder.get();
        return caches != null ? caches.keySet() : List.of();
    }

    protected abstract String getCacheKey();

    protected abstract int getScope();

    private ConcurrentMap<String, Cache> getCacheFromRequest(RequestAttributes requestAttributes) {
        return (ConcurrentMap)requestAttributes.getAttribute(this.getCacheKey(), this.getScope());
    }

    private boolean isCallingInWrapper() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(stack -> stack.getClassName().equals(RunnableWrapper.class.getName()) || stack.getClassName().equals(CallableWrapper.class.getName()));
    }
}

