/*
 * Decompiled with CFR 0.152.
 */
package tech.xujian.easydb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FieldUtils {
    public static Method getFieldGetMethod(Class<?> clazz, Field f) {
        String fn = f.getName();
        Method m = null;
        if (f.getType() == Boolean.TYPE) {
            m = FieldUtils.getBooleanFieldGetMethod(clazz, fn);
        }
        if (m == null) {
            m = FieldUtils.getFieldGetMethod(clazz, fn);
        }
        return m;
    }

    public static Method getBooleanFieldGetMethod(Class<?> clazz, String fieldName) {
        String mn = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (FieldUtils.isISStart(fieldName)) {
            mn = fieldName;
        }
        try {
            return clazz.getDeclaredMethod(mn, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean isISStart(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            return false;
        }
        return fieldName.startsWith("is") && !Character.isLowerCase(fieldName.charAt(2));
    }

    private static Method getFieldGetMethod(Class<?> clazz, String fieldName) {
        String mn = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return clazz.getDeclaredMethod(mn, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getBooleanFieldSetMethod(Class<?> clazz, Field f) {
        String fn = f.getName();
        String mn = "set" + fn.substring(0, 1).toUpperCase() + fn.substring(1);
        if (FieldUtils.isISStart(f.getName())) {
            mn = "set" + fn.substring(2, 3).toUpperCase() + fn.substring(3);
        }
        try {
            return clazz.getDeclaredMethod(mn, f.getType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getFieldSetMethod(Class<?> clazz, Field f) {
        String fn = f.getName();
        String mn = "set" + fn.substring(0, 1).toUpperCase() + fn.substring(1);
        try {
            return clazz.getDeclaredMethod(mn, f.getType());
        }
        catch (NoSuchMethodException e) {
            if (f.getType() == Boolean.TYPE) {
                return FieldUtils.getBooleanFieldSetMethod(clazz, f);
            }
            return null;
        }
    }

    public static Method getFieldSetMethod(Class<?> clazz, String fieldName) {
        try {
            return FieldUtils.getFieldSetMethod(clazz, clazz.getDeclaredField(fieldName));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }
}

