/*
 * Decompiled with CFR 0.152.
 */
package tech.xujian.easydb;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.xujian.easydb.DBHelper;
import tech.xujian.easydb.FieldUtils;
import tech.xujian.easydb.bean.EasyDB;

public class DBUtils {
    public static boolean save(Object obj) {
        return DBUtils.save(obj, null);
    }

    public static boolean save(Object obj, String table) {
        String sql = DBUtils.getSaveSQL(obj, table);
        if (sql == null) {
            System.out.println("\u751f\u6210SQL\u8bed\u53e5\u9519\u8bef");
            return false;
        }
        DBHelper dbHelper = new DBHelper(sql);
        boolean ret = false;
        try {
            ret = dbHelper.pst.execute();
            dbHelper.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            dbHelper.close();
        }
        return ret;
    }

    private static String getSaveSQL(Object obj, String table) {
        if (obj == null) {
            System.out.println("\u5b58\u50a8\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String tableName = null;
        tableName = table == null ? (obj instanceof EasyDB ? ((EasyDB)obj).getTableName() : obj.getClass().getSimpleName()) : table;
        String sql = "insert into " + tableName + " (";
        String names = "";
        String values = "'";
        Field[] filds = obj.getClass().getDeclaredFields();
        try {
            for (Field field : filds) {
                String name = field.getName();
                String getMethodName = FieldUtils.getFieldGetMethod(obj.getClass(), field).getName();
                String value = "" + obj.getClass().getMethod(getMethodName, new Class[0]).invoke(obj, new Object[0]);
                value = value.replaceAll("'", "-");
                names = names + name + ",";
                values = values + value + "','";
            }
            names = names.substring(0, names.length() - 1);
            values = values.substring(0, values.length() - 2);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        sql = sql + names + ") values (" + values + ")";
        return sql;
    }

    public static int saveList(List<?> objectList) {
        if (objectList.size() == 0) {
            return -1;
        }
        DBHelper dbHelper = new DBHelper();
        Connection conn = dbHelper.conn;
        try {
            conn.setAutoCommit(false);
            for (Object o : objectList) {
                String sql = DBUtils.getSaveSQL(o, null);
                if (sql == null) continue;
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.execute();
            }
            conn.commit();
            dbHelper.close();
            return objectList.size();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static <T> List<T> find(Class c, String[] items, String[] values) {
        String tableName = DBUtils.getTableNameByEasyDB(c);
        String sql = "select * from " + tableName;
        sql = sql + DBUtils.getWhereSQL(items, values);
        System.out.println(sql);
        DBHelper dbHelper = new DBHelper(sql);
        List<T> list = DBUtils.query(dbHelper, c);
        return list;
    }

    public static <T> List<T> find(Class c, String sql) {
        DBHelper dbHelper = new DBHelper(sql);
        List<T> list = DBUtils.query(dbHelper, c);
        return list;
    }

    public static List<Map<String, Object>> findMap(String sql) {
        DBHelper dbHelper = new DBHelper(sql);
        return DBUtils.queryMap(dbHelper);
    }

    public static boolean update(Class c, String[] setItems, String[] setValues, String[] whereItems, String[] whereValues) {
        return DBUtils.update(DBUtils.getTableNameByEasyDB(c), setItems, setValues, whereItems, whereValues);
    }

    public static boolean update(String tableName, String[] setItems, String[] setValues, String[] whereItems, String[] whereValues) {
        if (setItems == null || setItems.length == 0 || setValues == null || setValues.length != setItems.length) {
            return false;
        }
        String sql = "update " + tableName + " set ";
        for (int i = 0; i < setItems.length; ++i) {
            String key = setItems[i];
            String value = setValues[i];
            value = value.replaceAll("'", "-");
            sql = sql + key + " = '" + value + "' ,";
        }
        sql = sql.substring(0, sql.length() - 1);
        if ((sql = sql + DBUtils.getWhereSQL(whereItems, whereValues)).endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        System.out.println(sql);
        DBHelper dbHelper = new DBHelper(sql);
        return DBUtils.doSQL(dbHelper);
    }

    public static boolean execute(String sql) {
        DBHelper dbHelper = new DBHelper(sql);
        return DBUtils.doSQL(dbHelper);
    }

    public static boolean delete(Class c, String[] items, String[] values) {
        return DBUtils.delete(DBUtils.getTableNameByEasyDB(c), items, values);
    }

    private static String getTableNameByEasyDB(Class c) {
        try {
            Object obj = c.newInstance();
            if (obj instanceof EasyDB) {
                EasyDB easyDB = (EasyDB)obj;
                return easyDB.getTableName();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return c.getSimpleName().toLowerCase();
    }

    public static boolean delete(String tableName, String[] items, String[] values) {
        String sql = "delete from " + tableName;
        sql = sql + DBUtils.getWhereSQL(items, values);
        System.out.println(sql);
        DBHelper dbHelper = new DBHelper(sql);
        return DBUtils.doSQL(dbHelper);
    }

    private static boolean doSQL(DBHelper dbHelper) {
        try {
            dbHelper.pst.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            dbHelper.close();
            return false;
        }
        dbHelper.close();
        return true;
    }

    private static String getWhereSQL(String[] items, String[] values) {
        String sql = " ";
        if (items != null && values != null && items.length == values.length && items.length != 0) {
            sql = sql + " where ";
            for (int i = 0; i < items.length; ++i) {
                String key = items[i];
                String value = values[i];
                value = value.replaceAll("'", "-");
                sql = sql + key + " = '" + value + "' and ";
            }
            sql = sql.substring(0, sql.length() - " and ".length());
        }
        return sql;
    }

    private static String getWhereSQLOr(String[] items, String[] values) {
        String sql = " ";
        if (items != null && values != null && items.length == values.length && items.length != 0) {
            sql = sql + " where ";
            for (int i = 0; i < items.length; ++i) {
                String key = items[i];
                String value = values[i];
                value = value.replaceAll("'", "-");
                sql = sql + key + " = '" + value + "' or ";
            }
            sql = sql.substring(0, sql.length() - " or ".length());
        }
        return sql;
    }

    private static String toFirstLetterUpperCase(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        String firstLetter = str.substring(0, 1).toUpperCase();
        return firstLetter + str.substring(1, str.length());
    }

    public static <T> List<T> query(DBHelper dbHelper, Class c) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            ResultSet ret = dbHelper.pst.executeQuery();
            while (ret.next()) {
                Object obj = null;
                try {
                    obj = c.newInstance();
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                if (obj == null) {
                    ret.close();
                    dbHelper.close();
                    return list;
                }
                Field[] fields = c.getDeclaredFields();
                Class nC = c.getSuperclass();
                if (nC != null) {
                    Field field;
                    int n;
                    Field[] subFields = nC.getDeclaredFields();
                    Field[] nFileds = new Field[fields.length + subFields.length];
                    int i = 0;
                    Field[] fieldArray = fields;
                    int n2 = fieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        nFileds[i] = field = fieldArray[n];
                        ++i;
                    }
                    fieldArray = subFields;
                    n2 = fieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        nFileds[i] = field = fieldArray[n];
                        ++i;
                    }
                    fields = nFileds;
                }
                for (Field field : fields) {
                    String name = field.getName();
                    if (name.contains("password")) continue;
                    String colValue = "" + ret.getString(name);
                    Method m = FieldUtils.getFieldSetMethod(c, field);
                    if (m == null) continue;
                    String type = field.getType().getSimpleName();
                    if (type.equalsIgnoreCase("String")) {
                        m.invoke(obj, colValue);
                        continue;
                    }
                    if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("Integer")) {
                        if (colValue.length() == 0 || colValue.equalsIgnoreCase("null")) {
                            colValue = "0";
                        }
                        m.invoke(obj, Integer.parseInt(colValue));
                        continue;
                    }
                    if (type.equalsIgnoreCase("double") || type.equalsIgnoreCase("Double")) {
                        m.invoke(obj, Double.parseDouble(colValue));
                        continue;
                    }
                    if (type.equalsIgnoreCase("float") || type.equalsIgnoreCase("Float")) {
                        m.invoke(obj, Float.valueOf(Float.parseFloat(colValue)));
                        continue;
                    }
                    if (type.equalsIgnoreCase("boolean")) {
                        m.invoke(obj, colValue.equalsIgnoreCase("true"));
                        continue;
                    }
                    if (type.equalsIgnoreCase("long") || type.equalsIgnoreCase("Long")) {
                        m.invoke(obj, Long.parseLong(colValue));
                        continue;
                    }
                    m.invoke(obj, colValue);
                }
                list.add(obj);
            }
            ret.close();
            dbHelper.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            dbHelper.close();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            dbHelper.close();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            dbHelper.close();
        }
        return list;
    }

    private static List<Map<String, Object>> queryMap(DBHelper dbHelper) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        try {
            ResultSet ret = dbHelper.pst.executeQuery();
            while (ret.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                ResultSetMetaData m = ret.getMetaData();
                for (int i = 1; i <= m.getColumnCount(); ++i) {
                    map.put(m.getColumnName(i), ret.getString(m.getColumnName(i)));
                }
                maps.add(map);
            }
            ret.close();
            dbHelper.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            dbHelper.close();
        }
        return maps;
    }

    public static <T> List<T> findByOr(Class c, String[] items, String[] values) {
        String tableName = DBUtils.getTableNameByEasyDB(c);
        String sql = "select * from " + tableName;
        sql = sql + DBUtils.getWhereSQLOr(items, values);
        System.out.println(sql);
        DBHelper dbHelper = new DBHelper(sql);
        List<T> list = DBUtils.query(dbHelper, c);
        return list;
    }

    public static void insert(List<?> objs) {
        try {
            DBHelper dbHelper = new DBHelper();
            Connection conn = dbHelper.conn;
            conn.setAutoCommit(false);
            Statement st = conn.createStatement();
            for (Object obj : objs) {
                String sql = DBUtils.getSaveSQL(obj, null);
                st.addBatch(sql);
            }
            st.executeBatch();
            conn.commit();
            dbHelper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void doSQLs(List<String> sqls) {
        if (sqls == null || sqls.size() == 0) {
            return;
        }
        try {
            DBHelper dbHelper = new DBHelper();
            Connection conn = dbHelper.conn;
            conn.setAutoCommit(false);
            Statement st = conn.createStatement();
            for (String sql : sqls) {
                st.addBatch(sql);
            }
            st.executeBatch();
            conn.commit();
            dbHelper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T findOne(Class c, String sql) {
        List<T> list = DBUtils.find(c, sql);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }
}

