package tech.xmagic.api.runner;

import me.ahoo.cosid.IdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import tech.xmagic.api.utils.IdUtil;

/**
 * 工具配置
 * <p>
 * 在Spring应用上下文刷新后执行，初始化Util工具类
 * </p>
 *
 * @author meng2c
 * @since 2021.1.0
 */
@Component
public class UtilRunner implements ApplicationRunner {
    @Qualifier("__share__SnowflakeId")
    @Lazy
    @Autowired
    private IdGenerator snowflakeId;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        IdUtil.init(snowflakeId);
    }
}
