
//package cn.isigning.api.config;
//
//import com.google.common.collect.Lists;
//import io.swagger.annotations.ApiOperation;
//import lombok.Data;
//import org.springframework.boot.context.properties.ConfigurationProperties;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.http.HttpMethod;
//import springfox.documentation.builders.*;
//import springfox.documentation.oas.annotations.EnableOpenApi;
//import springfox.documentation.schema.ScalarType;
//import springfox.documentation.service.*;
//import springfox.documentation.spi.DocumentationType;
//import springfox.documentation.spi.service.contexts.SecurityContext;
//import springfox.documentation.spring.web.plugins.Docket;
//
//import java.util.ArrayList;
//import java.util.Collections;
//import java.util.List;
//
///**
// * Swagger3配置文件
// */
//@EnableOpenApi
//@Data
//@Configuration
//@ConfigurationProperties(prefix = "aos.api.swagger")
//public class Swagger3Config {
//    private String title;
//    private String description;
//    private String version;
//    private String groupName;
//    private boolean enable = false;
//
//    @Bean
//    public Docket createRestApi() {
//        return new Docket(DocumentationType.OAS_30)
//                // 定义是否开启swagger，false为关闭，可以通过变量控制
//                .enable(enable)
//                // 将api的元信息设置为包含在json ResourceListing响应中
//                .apiInfo(apiInfo())
//                .groupName("Swagger3接口")
//                // 支持的通讯协议集合
////                .protocols(newHashSet("https", "http"))
//                // 授权信息设置，必要的header token等认证信息
//                .securitySchemes(securitySchemes())
//                // 授权信息全局应用
//                .securityContexts(securityContexts())
//                .globalRequestParameters(getGlobalRequestParameters())
//                .globalResponses(HttpMethod.GET, getGlobalResonseMessage())
//                // 选择哪些接口作为swagger的doc发布
//                .select()
//                .apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class))
//                .paths(PathSelectors.any())
//                .build();
//    }
//
//    private ApiInfo apiInfo() {
//        return new ApiInfoBuilder()
//                .title("Swagger3接口文档")
//                .description("Swagger3 RESTful APIs")
//                .contact(new Contact("meng2c", "http://www.isigning.cn", ""))
//                .version("1.0.0")
//                .build();
//    }
//
//    /**
//     * 设置授权信息
//     */
//    private List<SecurityScheme> securitySchemes() {
////        return Collections.singletonList(new ApiKey("BASE_TOKEN", "token", "pass"));
//        return Collections.singletonList(new ApiKey("BearerToken", "Authorization", "header"));
//    }
//
//    private ApiKey apiKey() {
//        return new ApiKey("BearerToken", "Authorization", "header");
//    }
//
//    /**
//     * 授权信息全局应用
//     */
//    private List<SecurityContext> securityContexts() {
//        return Collections.singletonList(
//                SecurityContext.builder()
//                        .securityReferences(Collections.singletonList(
//                                new SecurityReference("BearerToken",
//                                        new AuthorizationScope[]{new AuthorizationScope("global", "")})))
//                        .build());
//    }
//
//    //生成全局通用参数
//    private List<RequestParameter> getGlobalRequestParameters() {
//        List<RequestParameter> parameters = new ArrayList<>();
//        parameters.add(new RequestParameterBuilder()
//                .name("x-api-version")
//                .description("版本")
////                .required(true)
//                .in(ParameterType.HEADER)
//                .query(q -> q.model(m -> m.scalarModel(ScalarType.STRING)))
////                .required(false)
//                .build());
////        parameters.add(new RequestParameterBuilder()
////                .name("udid")
////                .description("设备的唯一id")
////                .required(true)
////                .in(ParameterType.QUERY)
////                .query(q -> q.model(m -> m.scalarModel(ScalarType.STRING)))
////                .required(false)
////                .build());
////        parameters.add(new RequestParameterBuilder()
////                .name("version")
////                .description("客户端的版本号")
////                .required(true)
////                .in(ParameterType.QUERY)
////                .query(q -> q.model(m -> m.scalarModel(ScalarType.STRING)))
////                .required(false)
////                .build());
//        return parameters;
//    }
//
//    //生成通用响应信息
//    private List<Response> getGlobalResonseMessage() {
//        List<Response> responseList = new ArrayList<>();
//        responseList.add(new ResponseBuilder().code("200").description("请求成功").build());
//        responseList.add(new ResponseBuilder().code("401").description("未认证").build());
//        responseList.add(new ResponseBuilder().code("403").description("服务器拒绝").build());
//        responseList.add(new ResponseBuilder().code("404").description("找不到资源").build());
//        return responseList;
//    }
//
//
//    private SecurityContext securityContext() {
//        return SecurityContext.builder()
//                .securityReferences(defaultAuth())
//                .forPaths(PathSelectors.regex("/.*"))
//                .build();
//    }
//
//    List<SecurityReference> defaultAuth() {
//        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
//        AuthorizationScope[] authorizationScopes = new AuthorizationScope[1];
//        authorizationScopes[0] = authorizationScope;
//        return Lists.newArrayList(new SecurityReference("BearerToken", authorizationScopes));
//    }
//}



//package org.m2c.api.config;
//
//
//
//import io.swagger.v3.oas.models.Components;
//import io.swagger.v3.oas.models.ExternalDocumentation;
//import io.swagger.v3.oas.models.OpenAPI;
//import io.swagger.v3.oas.models.info.Info;
//import io.swagger.v3.oas.models.info.License;
//import io.swagger.v3.oas.models.security.SecurityRequirement;
//import io.swagger.v3.oas.models.security.SecurityScheme;
//import org.springdoc.core.GroupedOpenApi;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//
//import java.util.ArrayList;
//import java.util.List;
//
///**
// * @className: Swagger3Config
// * @description: Swagger配置
// * @author: clj
// * @date: 2022/2/25
// **/
//@Configuration
//public class Swagger3Config {
//    @Bean
//    public GroupedOpenApi allApi() {
//        return GroupedOpenApi.builder()
//                .group("qisu-teach-be")
//                .pathsToMatch("/**")
//                .build();
//    }
//
//    //全局安全认证
//    @Bean
//    public OpenAPI springShopOpenAPI() {
//        Components componentsHTTP = new Components()
//                .addSecuritySchemes("basicScheme", new SecurityScheme()
//                        .type(SecurityScheme.Type.HTTP).scheme("basic"));
//
//
//        SecurityRequirement securityRequirement = new SecurityRequirement().addList("Authorization"); // 名字和创建的SecuritySchemes一致
//        List<SecurityRequirement> list = new ArrayList<>();
//        list.add(securityRequirement);
//        return new OpenAPI()
//                .addSecurityItem(new SecurityRequirement().addList("Authorization", "认证令牌"))
////                .components(componentsAPIKEY)
//                .schemaRequirement("Authorization", new SecurityScheme()
//                        .type(SecurityScheme.Type.HTTP)
//                        .description("JWT格式的令牌")
//                        .scheme("bearer")
//                        .bearerFormat("JWT"))
////                .security(list)
//                .info(new Info().title("奇速教学端API服务")
//                        .description("奇速教学端API服务接口文档")
//                        .version("V5.2")
//                        .license(new License().name("奇速英语").url("http://xxx.com")))
//                .externalDocs(new ExternalDocumentation()
//                        .description("Knife4j文档")
//                        .url("/qisu-teach-be/doc.html"));
//    }
//}