package tech.xmagic.api.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 短信通道配置参数
 *
 * @author meng2c
 * @version 2022.3.1
 * @since 2022.2.17
 */
@Data
@ConfigurationProperties(prefix = ApiProperties.PREFIX)
public class ApiProperties {
    public final static String PREFIX = "api";//配置项前缀
    public final static String HTTP_STATUS_NAME = "httpStatus";//配置项前缀
    /**
     * API来源（可以是应用名，也可以是自定义字符串）
     */
    private String source;
    /**
     * 错误时返回的HttpStatus
     */
    private String httpStatus;

}
