package tech.xmagic.api.autoconfigure;

import tech.xmagic.api.advice.ExceptionControllerAdvice;
import tech.xmagic.api.advice.ExceptionControllerAdvice500;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;

/**
 * API服务-自动配置
 * <ul>
 * <li>导入ExceptionControllerAdvice通用的异常处理器</li>
 * <li>导入MybatisPlusConfig配置</li>
 * </ul>
 *
 * @author meng2c
 * @version 2022.5.1
 * @since 2022.5.7
 */
@AutoConfiguration
//@Import({ExceptionControllerAdvice.class, ResponseControllerAdvice.class})
@Import({ExceptionControllerAdvice.class, ExceptionControllerAdvice500.class, MybatisPlusConfig.class})
@EnableConfigurationProperties(ApiProperties.class)
public class ApiAutoConfiguration {

}
