package tech.xmagic.api.annotation;



import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import tech.xmagic.api.annotation.impl.NotBlankConditionConstraintValidator;


import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


@Documented
@Target({METHOD, FIELD})
@Retention(RUNTIME)
@Constraint(validatedBy = NotBlankConditionConstraintValidator.class)
public @interface NotBlankCondition {
    String message() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
