package tech.xmagic.api.advice;


import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import tech.xmagic.api.Result;
import tech.xmagic.api.annotation.ApiRestController;
import tech.xmagic.api.autoconfigure.ApiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

/**
 * 返回体封装
 * 暂未使用
 *
 * @author meng2c
 * @since 1.0.0
 */
@Deprecated
@Slf4j
@RestControllerAdvice(annotations = {ApiRestController.class})
public class ResponseControllerAdvice implements ResponseBodyAdvice<Object> {
    //    @Value("${api.source}")
    @Autowired
    private ApiProperties apiProperties;

    @Override
    public boolean supports(MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> aClass) {
//        获取泛型
//        ((ParameterizedType)returnType.getGenericParameterType()).getActualTypeArguments()[0]
//        Type type = returnType.getGenericParameterType();
//        if (type instanceof ParameterizedType) {
//            return !((ParameterizedType) type).getRawType().equals(Result.class);
//        }
//        return !type.equals(Result.class);
//        Method method = returnType.getMethod();
//        method.getReturnType().isAssignableFrom()
        return !returnType.hasMethodAnnotation(IgnoreRestBody.class);
    }

    @Override
    public Object beforeBodyWrite(Object body,
                                  @NonNull MethodParameter returnType,
                                  @NonNull MediaType selectedContentType,
                                  @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType,
                                  @NonNull ServerHttpRequest request,
                                  @NonNull ServerHttpResponse response) {
        Result<?> result;
        if (body == null) {
            result = Result.success();
        } else if (Result.class.isAssignableFrom(body.getClass())) {
            result = (Result<?>) body;
        } else if (checkPrimitive(body)) {
//            return Result.success(Collections.singletonMap("result", body));
            result = Result.success(body);
        } else {
            result = Result.success(body);
        }
        if (StrUtil.isNotBlank(apiProperties.getSource()))
            result.setSource(apiProperties.getSource());
        if (checkString(body) || StringHttpMessageConverter.class.isAssignableFrom(selectedConverterType)) {
            response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            return JSONUtil.toJsonStr(result);
        } else {
            return result;
        }

        // String类型不能直接包装，所以要进行些特别的处理
        //获取返回类型
//        if (returnType.getGenericParameterType().equals(String.class)) {
//            ObjectMapper objectMapper = new ObjectMapper();
//            try {
//                // 将数据包装在ResultVO里后，再转换为json字符串响应给前端
//                Result result = new Result();
//                return objectMapper.writeValueAsString(result);
//            } catch (JsonProcessingException e) {
////                throw new ApiException("返回String类型错误");
//            }
//        }
//        if (data instanceof Result)
//            return data;
//        // 将原本的数据包装在ResultVO里
//        Result result = Result.success(data);
//        return result;
    }

    private boolean checkString(Object body) {
        return body instanceof Character
                || body instanceof String;
    }

    private boolean checkPrimitive(Object body) {
        Class<?> clazz = body.getClass();
        return clazz.isPrimitive()//指定的Class对象表示一个基本类型
                || clazz.isArray()//指定的Class对象是一个数组
                || Collection.class.isAssignableFrom(clazz)//指定的Class对象是一个集合
                || body instanceof Number
                || body instanceof Boolean
                || body instanceof Character
                || body instanceof String;
    }

    /**
     * 获取泛型的实际类型
     *
     * @param type
     * @return
     */
    private Class<?> getImportClass(Type type) {
        return (Class<?>) ((ParameterizedType) type.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}