/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import tech.xigam.cch.ComplexCommandHandler;
import tech.xigam.cch.command.BaseCommand;

public final class InteractiveArguments {
    private static final Map<String, Integer> index = new HashMap<String, Integer>();
    private final List<String> questions;
    private final Member member;
    private final BaseCommand command;
    private final TextChannel channel;
    private final Message message;
    private final ComplexCommandHandler handler;
    private final Map<Integer, String> answers = new HashMap<Integer, String>();

    public InteractiveArguments(Message replyTo, Member member, BaseCommand toExecute, List<String> questions, ComplexCommandHandler handler) {
        this.message = replyTo;
        this.member = member;
        this.command = toExecute;
        this.questions = questions;
        this.channel = replyTo.getChannel().asTextChannel();
        this.handler = handler;
    }

    public void start(Message replyTo) {
        if (index.containsKey(this.member.getId())) {
            return;
        }
        index.put(this.member.getId(), 0);
        replyTo.reply((CharSequence)this.questions.get(index.get(this.member.getId()))).queue();
    }

    public void advance(Message response) {
        this.answers.put(index.get(this.member.getId()), response.getContentRaw());
        index.put(this.member.getId(), index.get(this.member.getId()) + 1);
        if (index.get(this.member.getId()) + 1 > this.questions.size()) {
            this.handler.destroyInteraction(this);
            index.remove(this.member.getId());
            this.command.prepareForExecution(new ArrayList<String>(this.answers.values()), this.message, this.member, (MessageChannel)this.channel, false, this.handler);
        } else {
            ((MessageCreateAction)response.reply((CharSequence)this.questions.get(index.get(this.member.getId()))).mentionRepliedUser(false)).queue();
        }
    }

    public Member getMember() {
        return this.member;
    }

    public TextChannel getChannel() {
        return this.channel;
    }
}

