/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.StringSelectInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import tech.xigam.cch.ComplexCommandHandler;
import tech.xigam.cch.command.BaseCommand;
import tech.xigam.cch.command.SubCommand;
import tech.xigam.cch.command.modifiers.Arguments;
import tech.xigam.cch.command.modifiers.Baseless;
import tech.xigam.cch.command.modifiers.Callable;
import tech.xigam.cch.command.modifiers.Completable;
import tech.xigam.cch.command.modifiers.Limited;
import tech.xigam.cch.command.modifiers.Restricted;
import tech.xigam.cch.utils.Argument;
import tech.xigam.cch.utils.Callback;
import tech.xigam.cch.utils.Completion;
import tech.xigam.cch.utils.Interaction;
import tech.xigam.cch.utils.InteractiveArguments;

public abstract class Command
implements BaseCommand {
    private final String label;
    private final String description;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();
    private List<String> interactiveArguments = new ArrayList<String>();

    public Command(String label, String description) {
        this.label = label;
        this.description = description;
    }

    public Command(String label, String description, String ... argumentQuestions) {
        this.label = label;
        this.description = description;
        this.interactiveArguments = List.of(argumentQuestions);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void prepareForExecution(List<String> arguments, Message message, Member sender, MessageChannel channel, boolean skipArguments, ComplexCommandHandler handler) {
        Limited limited;
        Command command = this;
        if (command instanceof Limited && (limited = (Limited)((Object)command)).isGuildOnly() && !message.isFromGuild()) {
            handler.onContextError.accept(new Interaction(handler, message, channel, arguments, this), new Exception("This command can only be executed in a guild."));
            return;
        }
        command = this;
        if (command instanceof Restricted) {
            Restricted restricted = (Restricted)((Object)command);
            if (sender != null && !sender.hasPermission(restricted.getPermissions())) {
                handler.onContextError.accept(new Interaction(handler, message, channel, arguments, this), new Exception("You do not have permission to execute this command."));
                return;
            }
        }
        ArrayList<String> args = new ArrayList<String>(arguments);
        boolean executeBase = true;
        for (String argument : arguments) {
            if (!this.subCommands.containsKey(argument)) continue;
            executeBase = false;
            args.remove(argument);
            this.getSubCommand(argument).prepareForExecution(args, message, sender, channel, false, handler);
        }
        if (executeBase) {
            if (this instanceof Arguments) {
                int requiredArguments = 0;
                for (Argument argument : ((Arguments)((Object)this)).getArguments()) {
                    if (!argument.required) continue;
                    ++requiredArguments;
                }
                if (args.size() < requiredArguments) {
                    handler.onArgumentError.accept(new Interaction(handler, message, channel, arguments, this));
                    return;
                }
            }
            if (this.interactiveArguments.isEmpty() || skipArguments) {
                this.execute(new Interaction(handler, message, channel, arguments, this));
            } else {
                new InteractiveArguments(message, sender, this, this.interactiveArguments, handler);
            }
        }
    }

    @Override
    public void prepareForExecution(SlashCommandInteractionEvent event, ComplexCommandHandler handler) {
        Limited limited;
        Command command = this;
        if (command instanceof Limited && (limited = (Limited)((Object)command)).isGuildOnly() && !event.isFromGuild()) {
            handler.onContextError.accept(new Interaction(handler, event, this), new Exception("This command can only be executed in a guild."));
            return;
        }
        command = this;
        if (command instanceof Restricted) {
            Restricted restricted = (Restricted)((Object)command);
            Member member = event.getMember();
            if (member != null && !member.hasPermission(restricted.getPermissions())) {
                handler.onContextError.accept(new Interaction(handler, event, this), new Exception("You do not have permission to execute this command."));
                return;
            }
        }
        String subCommand = null;
        if (this instanceof Baseless) {
            subCommand = event.getSubcommandName();
        } else {
            OptionMapping option = event.getOption("action");
            if (option != null) {
                subCommand = option.getAsString();
            }
        }
        if (subCommand != null && this.subCommands.containsKey(subCommand)) {
            this.getSubCommand(subCommand).execute(new Interaction(handler, event, this.getSubCommand(subCommand)));
            return;
        }
        this.execute(new Interaction(handler, event, this));
    }

    @Override
    public void prepareForCompletion(CommandAutoCompleteInteractionEvent event, ComplexCommandHandler handler) {
        String subCommand = null;
        if (this instanceof Baseless) {
            subCommand = event.getSubcommandName();
        } else {
            OptionMapping option = event.getOption("action");
            if (option != null) {
                subCommand = option.getAsString();
            }
        }
        if (subCommand != null && this.subCommands.containsKey(subCommand)) {
            SubCommand subCmd = this.getSubCommand(subCommand);
            if (subCmd instanceof Completable) {
                Completable completable = (Completable)((Object)subCmd);
                completable.complete(new Completion(event));
            }
            return;
        }
        Command command = this;
        if (command instanceof Completable) {
            Completable completable = (Completable)((Object)command);
            completable.complete(new Completion(event));
        }
    }

    @Override
    public void prepareForCallback(String cmdLabel, ButtonInteractionEvent event, ComplexCommandHandler handler) {
        if (this.subCommands.containsKey(cmdLabel)) {
            SubCommand subCmd = this.getSubCommand(cmdLabel);
            if (subCmd instanceof Callable) {
                Callable callable = (Callable)((Object)subCmd);
                callable.callback(new Callback(event));
            }
            return;
        }
        Command command = this;
        if (command instanceof Callable) {
            Callable callable = (Callable)((Object)command);
            callable.callback(new Callback(event));
        }
    }

    @Override
    public void prepareForCallback(String cmdLabel, StringSelectInteractionEvent event, ComplexCommandHandler handler) {
        if (this.subCommands.containsKey(cmdLabel)) {
            SubCommand subCmd = this.getSubCommand(cmdLabel);
            if (subCmd instanceof Callable) {
                Callable callable = (Callable)((Object)subCmd);
                callable.callback(new Callback(event));
            }
            return;
        }
        Command command = this;
        if (command instanceof Callable) {
            Callable callable = (Callable)((Object)command);
            callable.callback(new Callback(event));
        }
    }

    public final Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    protected final void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getLabel(), subCommand);
    }

    private SubCommand getSubCommand(String label) {
        return this.subCommands.get(label);
    }
}

