/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import tech.xigam.cch.ComplexCommandHandler;
import tech.xigam.cch.command.Arguments;
import tech.xigam.cch.command.BaseCommand;
import tech.xigam.cch.utils.Argument;

public final class Interaction {
    private final boolean isSlash;
    private final boolean inGuild;
    private final ComplexCommandHandler commandHandler;
    private final User user;
    @Nullable
    private final Member member;
    @Nullable
    private final Message message;
    private final MessageChannel channel;
    @Nullable
    private final Guild guild;
    private final BaseCommand command;
    private SlashCommandInteractionEvent slashExecutor = null;
    private boolean ephemeral = false;
    private boolean sendToDMs = false;
    private boolean deferred = false;
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private final List<String> rawArguments = new ArrayList<String>();
    private final List<ActionRow> actionRows = new ArrayList<ActionRow>();

    public Interaction(ComplexCommandHandler commandHandler, SlashCommandInteractionEvent event, BaseCommand command) {
        this.commandHandler = commandHandler;
        this.isSlash = true;
        this.inGuild = event.isFromGuild();
        this.slashExecutor = event;
        this.user = event.getUser();
        this.member = event.getMember();
        this.message = null;
        this.channel = event.getChannel();
        this.guild = event.getGuild();
        this.command = command;
        if (command instanceof Arguments) {
            Arguments argsCmd = (Arguments)((Object)command);
            Map<String, OptionType> argumentTypes = Argument.toOptions(argsCmd.getArguments().toArray(new Argument[0]));
            for (Map.Entry<String, OptionType> entry : argumentTypes.entrySet()) {
                OptionMapping mapping = event.getOption(entry.getKey());
                if (mapping == null) continue;
                switch (entry.getValue()) {
                    case STRING: {
                        this.arguments.put(entry.getKey(), mapping.getAsString());
                        break;
                    }
                    case INTEGER: 
                    case NUMBER: {
                        this.arguments.put(entry.getKey(), mapping.getAsLong());
                        break;
                    }
                    case BOOLEAN: {
                        this.arguments.put(entry.getKey(), mapping.getAsBoolean());
                        break;
                    }
                    case MENTIONABLE: {
                        this.arguments.put(entry.getKey(), mapping.getAsMentionable());
                        break;
                    }
                    case USER: {
                        this.arguments.put(entry.getKey(), mapping.getAsMember());
                        break;
                    }
                    case ROLE: {
                        this.arguments.put(entry.getKey(), mapping.getAsRole());
                        break;
                    }
                    case CHANNEL: {
                        this.arguments.put(entry.getKey(), mapping.getAsGuildChannel());
                        break;
                    }
                    case ATTACHMENT: {
                        this.arguments.put(entry.getKey(), mapping.getAsAttachment());
                    }
                }
            }
        }
    }

    public Interaction(ComplexCommandHandler commandHandler, Message message, TextChannel channel, List<String> arguments, BaseCommand command) {
        this.commandHandler = commandHandler;
        this.isSlash = false;
        this.inGuild = message.isFromGuild();
        this.user = message.getAuthor();
        this.member = message.getMember();
        this.message = message;
        this.channel = channel;
        this.guild = channel.getGuild();
        this.command = command;
        if (command instanceof Arguments) {
            Arguments argsCmd = (Arguments)((Object)command);
            Argument[] args = argsCmd.getArguments().toArray(new Argument[0]);
            try {
                int attachmentCount = 0;
                block10: for (int i = 0; i < args.length; ++i) {
                    Argument argument = args[i];
                    if (argument.trailing) {
                        String combined = String.join((CharSequence)" ", arguments.subList(i, arguments.size()));
                        this.arguments.put(argument.reference, combined);
                        this.rawArguments.add(combined);
                        break;
                    }
                    switch (argument.argumentType) {
                        default: {
                            this.arguments.put(argument.reference, arguments.get(argument.position));
                            continue block10;
                        }
                        case INTEGER: 
                        case NUMBER: {
                            this.arguments.put(argument.reference, Long.parseLong(arguments.get(argument.position)));
                            continue block10;
                        }
                        case BOOLEAN: {
                            this.arguments.put(argument.reference, Boolean.parseBoolean(arguments.get(argument.position)));
                            continue block10;
                        }
                        case MENTIONABLE: 
                        case USER: {
                            this.arguments.put(argument.reference, this.guild.getMemberById(arguments.get(argument.position).replaceAll("[^0-9]", "")));
                            continue block10;
                        }
                        case ROLE: {
                            this.arguments.put(argument.reference, this.guild.getRoleById(arguments.get(argument.position).replaceAll("[^0-9]", "")));
                            continue block10;
                        }
                        case CHANNEL: {
                            this.arguments.put(argument.reference, this.guild.getGuildChannelById(arguments.get(argument.position).replaceAll("[^0-9]", "")));
                            continue block10;
                        }
                        case ATTACHMENT: {
                            this.arguments.put(argument.reference, message.getAttachments().get(attachmentCount++));
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.rawArguments.addAll(arguments);
    }

    public ComplexCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    @Deprecated(since="1.6.0")
    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    @Deprecated(since="1.6.0")
    public List<String> getRawArguments() {
        return this.rawArguments;
    }

    public <T> T getArgument(String reference, Class<T> type) {
        return type.cast(this.arguments.get(reference));
    }

    public <T> T getArgument(String reference, T fallback, Class<T> type) {
        return type.cast(this.arguments.getOrDefault(reference, fallback));
    }

    @Nullable
    public SlashCommandInteractionEvent getSlashExecutor() {
        return this.slashExecutor;
    }

    public boolean isSlash() {
        return this.isSlash;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public boolean isFromGuild() {
        return this.inGuild;
    }

    public void deferReply() {
        if (this.isSlash) {
            this.slashExecutor.deferReply(this.ephemeral).queue();
        } else {
            this.getChannel().sendTyping().queue();
        }
        this.deferred = true;
    }

    public Interaction setEphemeral() {
        this.ephemeral = true;
        return this;
    }

    public Interaction setEphemeral(boolean sendToDMs) {
        this.ephemeral = true;
        this.sendToDMs = sendToDMs;
        return this;
    }

    public Interaction addButtons(Button ... buttons) {
        this.actionRows.add(ActionRow.of((ItemComponent[])buttons));
        return this;
    }

    public Interaction addSelectMenu(SelectMenu menu) {
        this.actionRows.add(ActionRow.of((ItemComponent[])new ItemComponent[]{menu}));
        return this;
    }

    public Interaction sendMessage(String message) {
        this.getChannel().sendMessage((CharSequence)message).queue();
        return this;
    }

    public Interaction sendMessage(MessageEmbed message) {
        this.getChannel().sendMessageEmbeds(message, new MessageEmbed[0]).queue();
        return this;
    }

    public void reply(String message) {
        this.reply(message, true);
    }

    public void reply(MessageEmbed embed) {
        this.reply(embed, true);
    }

    public void reply(String message, boolean mentionUser) {
        this.send(message, mentionUser);
    }

    public void reply(MessageEmbed message, boolean mentionUser) {
        this.send(message, mentionUser);
    }

    public void execute(final Consumer<Interaction> consumer, long after, TimeUnit timeUnit) {
        final Interaction interaction = this;
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                consumer.accept(interaction);
            }
        }, timeUnit.toMillis(after));
    }

    private void send(Object message, boolean mentionUser) {
        if (this.isSlash()) {
            if (this.isDeferred()) {
                WebhookMessageAction send = message instanceof String ? this.slashExecutor.getHook().sendMessage((String)message) : this.slashExecutor.getHook().sendMessageEmbeds((MessageEmbed)message, new MessageEmbed[0]);
                if (!this.actionRows.isEmpty()) {
                    send = send.addActionRows(this.actionRows);
                }
                send.queue();
            } else {
                ReplyCallbackAction send = message instanceof String ? this.slashExecutor.reply((String)message) : this.slashExecutor.replyEmbeds((MessageEmbed)message, new MessageEmbed[0]);
                if (!this.actionRows.isEmpty()) {
                    send = send.addActionRows(this.actionRows);
                }
                send.setEphemeral(this.isEphemeral()).queue();
            }
        } else if (this.isEphemeral() && this.sendToDMs) {
            this.getUser().openPrivateChannel().queue(privateChannel -> {
                MessageAction send = message instanceof String ? privateChannel.sendMessage((CharSequence)((String)message)) : privateChannel.sendMessageEmbeds((MessageEmbed)message, new MessageEmbed[0]);
                if (!this.actionRows.isEmpty()) {
                    send = send.setActionRows(this.actionRows);
                }
                send.queue();
            });
        } else {
            MessageAction send = message instanceof String ? this.getMessage().reply((CharSequence)((String)message)) : this.getMessage().replyEmbeds((MessageEmbed)message, new MessageEmbed[0]);
            if (!this.actionRows.isEmpty()) {
                send = send.setActionRows(this.actionRows);
            }
            send.mentionRepliedUser(mentionUser).queue();
        }
    }

    public User getUser() {
        return this.user;
    }

    @Nullable
    public Member getMember() {
        return this.member;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    public BaseCommand getCommand() {
        return this.command;
    }
}

