/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.component.SelectMenuInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;

public final class Callback {
    private final String reference;
    @Nullable
    private final Member member;
    private final GenericComponentInteractionCreateEvent interactionExecutor;
    private Type deferred = Type.NONE;
    private List<String> selected = new ArrayList<String>();

    public Callback(ButtonInteractionEvent event) {
        this.interactionExecutor = event;
        this.member = event.getMember();
        String rawReference = event.getComponentId();
        this.reference = rawReference.split(">")[1];
    }

    public Callback(SelectMenuInteractionEvent event) {
        this.interactionExecutor = event;
        this.member = event.getMember();
        String rawReference = event.getComponentId();
        this.reference = rawReference.split(">")[1];
        this.selected = event.getSelectedOptions().stream().map(SelectOption::getValue).toList();
    }

    public String getReference() {
        return this.reference;
    }

    public List<String> getSelectedOptions() {
        return this.selected;
    }

    @Nullable
    public Member getMember() {
        return this.member;
    }

    public Callback deferEdit() {
        this.interactionExecutor.deferEdit().queue();
        this.deferred = Type.EDIT;
        return this;
    }

    public Callback deferReply() {
        this.interactionExecutor.deferReply().queue();
        this.deferred = Type.REPLY;
        return this;
    }

    public void edit(String message) {
        this.send(message, Type.EDIT);
    }

    public void reply(String message) {
        this.send(message, Type.REPLY);
    }

    public void edit(MessageEmbed embed) {
        this.send(embed, Type.EDIT);
    }

    public void reply(MessageEmbed embed) {
        this.send(embed, Type.REPLY);
    }

    public Callback edit(Button ... buttons) {
        this.edit(ActionRow.of((ItemComponent[])buttons));
        return this;
    }

    public Callback edit(SelectMenu menu) {
        this.edit(ActionRow.of((ItemComponent[])new ItemComponent[]{menu}));
        return this;
    }

    public Callback edit(ActionRow row) {
        this.send(row, Type.EDIT);
        return this;
    }

    private void send(Object message, Type type) {
        switch (this.deferred) {
            case EDIT: {
                InteractionHook hook = this.interactionExecutor.getHook();
                if (message instanceof String) {
                    String msg = (String)message;
                    hook.editOriginal(msg).queue();
                    break;
                }
                if (message instanceof MessageEmbed) {
                    MessageEmbed embed = (MessageEmbed)message;
                    hook.editOriginalEmbeds(new MessageEmbed[]{embed}).queue();
                    break;
                }
                if (!(message instanceof ActionRow)) break;
                ActionRow row = (ActionRow)message;
                hook.editOriginalComponents(new LayoutComponent[]{row}).queue();
                break;
            }
            case REPLY: {
                InteractionHook hook = this.interactionExecutor.getHook();
                if (message instanceof String) {
                    String msg = (String)message;
                    hook.sendMessage(msg).queue();
                    break;
                }
                if (!(message instanceof MessageEmbed)) break;
                MessageEmbed embed = (MessageEmbed)message;
                hook.sendMessageEmbeds(embed, new MessageEmbed[0]).queue();
                break;
            }
            case NONE: {
                if (type == Type.EDIT) {
                    if (message instanceof String) {
                        String msg = (String)message;
                        this.interactionExecutor.editMessage(msg).queue();
                        break;
                    }
                    if (!(message instanceof MessageEmbed)) break;
                    MessageEmbed embed = (MessageEmbed)message;
                    this.interactionExecutor.editMessageEmbeds(new MessageEmbed[]{embed}).queue();
                    break;
                }
                if (message instanceof String) {
                    String msg = (String)message;
                    this.interactionExecutor.reply(msg).queue();
                    break;
                }
                if (!(message instanceof MessageEmbed)) break;
                MessageEmbed embed = (MessageEmbed)message;
                this.interactionExecutor.replyEmbeds(embed, new MessageEmbed[0]).queue();
            }
        }
    }

    private static enum Type {
        NONE,
        EDIT,
        REPLY;

    }
}

