/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.defaults;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import tech.xigam.cch.command.Arguments;
import tech.xigam.cch.command.Command;
import tech.xigam.cch.utils.Argument;
import tech.xigam.cch.utils.Interaction;

public abstract class DeployCommand
extends Command
implements Arguments {
    public DeployCommand() {
        super("deploy", "Deploys all registered commands to your guild or globally.");
    }

    protected abstract boolean permissionCheck(Interaction var1);

    @Nullable
    protected MessageEmbed embedify(String text) {
        return null;
    }

    @Override
    public void execute(Interaction interaction) {
        MessageEmbed embed;
        if (!this.permissionCheck(interaction)) {
            interaction.reply("You don't have permission to deploy commands.");
            return;
        }
        Boolean global = interaction.getArgument("global", false, Boolean.class);
        Boolean delete = interaction.getArgument("delete", false, Boolean.class);
        if (!global.booleanValue() && !interaction.isFromGuild()) {
            global = true;
            embed = this.embedify("You can't deploy slash commands to a DM, deploying globally instead.");
            if (embed == null) {
                interaction.reply("You can't deploy slash commands to a DM, deploying globally instead.");
            } else {
                interaction.reply(embed);
            }
        }
        if (delete.booleanValue()) {
            interaction.getCommandHandler().downsert(global != false ? null : interaction.getGuild());
            embed = this.embedify("Deleted all commands.");
            if (embed == null) {
                interaction.reply("Deleted all commands.");
            } else {
                interaction.reply(embed);
            }
        } else {
            interaction.getCommandHandler().deployAll(global != false ? null : interaction.getGuild());
            embed = this.embedify("Deployed all commands.");
            if (embed == null) {
                interaction.reply("Deployed all commands.");
            } else {
                interaction.reply(embed);
            }
        }
    }

    @Override
    public Collection<Argument> getArguments() {
        return List.of(Argument.createWithChoices("global", "Should the commands be deployed globally?", "global", OptionType.BOOLEAN, true, 0, new String[0]), Argument.createWithChoices("delete", "Should commands be deleted instead of upserted?", "delete", OptionType.BOOLEAN, false, 1, new String[0]));
    }
}

