/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.command;

import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.SelectMenuInteractionEvent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import tech.xigam.cch.ComplexCommandHandler;
import tech.xigam.cch.utils.Interaction;
import tech.xigam.cch.utils.MenuOption;
import tech.xigam.cch.utils.Validation;

public interface BaseCommand {
    public String getLabel();

    public String getDescription();

    public void execute(Interaction var1);

    public void prepareForExecution(List<String> var1, Message var2, Member var3, TextChannel var4, boolean var5, ComplexCommandHandler var6);

    public void prepareForExecution(SlashCommandInteractionEvent var1, ComplexCommandHandler var2);

    public void prepareForCompletion(CommandAutoCompleteInteractionEvent var1, ComplexCommandHandler var2);

    public void prepareForCallback(String var1, ButtonInteractionEvent var2, ComplexCommandHandler var3);

    public void prepareForCallback(String var1, SelectMenuInteractionEvent var2, ComplexCommandHandler var3);

    default public Button createButton(ButtonStyle style, String reference, String text) {
        return Button.of((ButtonStyle)style, (String)(Validation.isUrl(reference) ? reference : "<" + this.getLabel().toLowerCase() + ">" + reference), (String)text);
    }

    default public Button createButton(ButtonStyle style, String reference, Emoji emoji) {
        return Button.of((ButtonStyle)style, (String)(Validation.isUrl(reference) ? reference : "<" + this.getLabel().toLowerCase() + ">" + reference), (Emoji)emoji);
    }

    default public Button createButton(ButtonStyle style, String reference, String text, Emoji emoji) {
        return Button.of((ButtonStyle)style, (String)(Validation.isUrl(reference) ? reference : "<" + this.getLabel().toLowerCase() + ">" + reference), (String)text, (Emoji)emoji);
    }

    default public SelectMenu createSelectMenu(String reference, MenuOption ... options) {
        if (options.length == 0) {
            throw new IllegalArgumentException("At least one option must be provided.");
        }
        return SelectMenu.create((String)("<" + this.getLabel().toLowerCase() + ">" + reference)).addOptions(Arrays.stream(options).map(MenuOption::asOption).toList()).build();
    }

    default public SelectMenu createSelectMenu(String reference, String placeHolder, MenuOption ... options) {
        if (options.length == 0) {
            throw new IllegalArgumentException("At least one option must be provided.");
        }
        return SelectMenu.create((String)("<" + this.getLabel().toLowerCase() + ">" + reference)).setPlaceholder(placeHolder).addOptions(Arrays.stream(options).map(MenuOption::asOption).toList()).build();
    }
}

