/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.SelectMenuInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.requests.restaction.CommandCreateAction;
import org.jetbrains.annotations.NotNull;
import tech.xigam.cch.command.Alias;
import tech.xigam.cch.command.Arguments;
import tech.xigam.cch.command.BaseCommand;
import tech.xigam.cch.command.Baseless;
import tech.xigam.cch.command.Command;
import tech.xigam.cch.command.SubCommand;
import tech.xigam.cch.utils.Argument;
import tech.xigam.cch.utils.Interaction;
import tech.xigam.cch.utils.InteractiveArguments;

public final class ComplexCommandHandler
extends ListenerAdapter {
    private JDA jdaInstance;
    private final boolean usePrefix;
    private final Map<String, BaseCommand> commands = new HashMap<String, BaseCommand>();
    private final Map<String, InteractiveArguments> argumentSessions = new HashMap<String, InteractiveArguments>();
    private String prefix;
    public Consumer<Interaction> onArgumentError = interaction -> {};

    public ComplexCommandHandler(boolean usePrefix) {
        this.usePrefix = usePrefix;
    }

    public ComplexCommandHandler setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ComplexCommandHandler registerCommand(BaseCommand command) {
        this.commands.put(command.getLabel(), command);
        return this;
    }

    public void setJda(JDA jda) {
        jda.addEventListener(new Object[]{this});
        this.jdaInstance = jda;
    }

    public Map<String, BaseCommand> getRegisteredCommands() {
        return new HashMap<String, BaseCommand>(this.commands);
    }

    private void runCommand(String command, MessageReceivedEvent event) {
        this.executeCommand(command, event.getMessage(), event.getMember(), event.getTextChannel());
    }

    private void runCommand(String command, MessageUpdateEvent event) {
        this.executeCommand(command, event.getMessage(), event.getMember(), event.getTextChannel());
    }

    private void runCommand(SlashCommandInteractionEvent event) {
        if (!this.commands.containsKey(event.getName())) {
            event.reply("Command not found.").queue();
            return;
        }
        this.commands.get(event.getName()).prepareForExecution(event, this);
    }

    private void executeCommand(String command, Message message2, Member member, TextChannel textChannel) {
        if (!this.commands.containsKey(command)) {
            return;
        }
        String message = message2.getContentRaw();
        String[] splitMessage = message.split(" ");
        ArrayList<String> arguments = new ArrayList<String>();
        for (String argument : splitMessage) {
            if (argument.startsWith(this.prefix)) continue;
            arguments.add(argument);
        }
        this.commands.get(command).prepareForExecution(arguments, message2, member, textChannel, false, this);
    }

    public void checkMessageInteraction(Message message) {
        if (message.getMember() == null) {
            return;
        }
        String memberId = message.getMember().getId();
        String channelId = message.getChannel().getId();
        if (!this.argumentSessions.containsKey(memberId)) {
            return;
        }
        if (!channelId.matches(this.argumentSessions.get(memberId).getChannel().getId())) {
            return;
        }
        this.argumentSessions.get(memberId).advance(message);
    }

    public void destroyInteraction(InteractiveArguments session) {
        this.argumentSessions.remove(session.getMember().getId());
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (!this.usePrefix) {
            return;
        }
        if (event.getAuthor().isBot()) {
            return;
        }
        if (!event.getMessage().getContentRaw().startsWith(this.prefix)) {
            this.checkMessageInteraction(event.getMessage());
            return;
        }
        String message = event.getMessage().getContentRaw();
        if (message.split(this.prefix).length < 2) {
            return;
        }
        this.runCommand(message.split(this.prefix)[1].split(" ")[0], event);
    }

    public void onMessageUpdate(@NotNull MessageUpdateEvent event) {
        if (!this.usePrefix) {
            return;
        }
        if (event.getAuthor().isBot()) {
            return;
        }
        String message = event.getMessage().getContentRaw();
        if (!message.startsWith(this.prefix)) {
            return;
        }
        if (message.split(this.prefix).length < 2) {
            return;
        }
        this.runCommand(message.split(this.prefix)[1].split(" ")[0], event);
    }

    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        this.runCommand(event);
    }

    public void onCommandAutoCompleteInteraction(@NotNull CommandAutoCompleteInteractionEvent event) {
        if (!this.commands.containsKey(event.getName())) {
            return;
        }
        BaseCommand command = this.commands.get(event.getName());
        command.prepareForCompletion(event, this);
    }

    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        String rawReference = event.getComponentId();
        if (!rawReference.startsWith("<")) {
            return;
        }
        String label = rawReference.split("<")[1].split(">")[0];
        BaseCommand command = this.commands.get(label);
        command.prepareForCallback(label, event, this);
    }

    public void onSelectMenuInteraction(@NotNull SelectMenuInteractionEvent event) {
        String rawReference = event.getComponentId();
        if (!rawReference.startsWith("<")) {
            return;
        }
        String label = rawReference.split("<")[1].split(">")[0];
        BaseCommand command = this.commands.get(label);
        command.prepareForCallback(label, event, this);
    }

    public void downsert(@Nullable Guild guild) {
        if (guild == null) {
            this.jdaInstance.updateCommands().addCommands(new CommandData[0]).queue();
        } else {
            guild.updateCommands().addCommands(new CommandData[0]).queue();
        }
    }

    public void deployAll(@Nullable Guild guild) {
        try {
            ArrayList commands = new ArrayList();
            this.commands.forEach((label, command) -> {
                SlashCommandData action = Commands.slash((String)label, (String)command.getDescription());
                for (SubCommand subCommand : ((Command)command).getSubCommands().values()) {
                    if (command instanceof Baseless) {
                        SubcommandData cmdData = new SubcommandData(subCommand.getLabel(), subCommand.getDescription());
                        if (subCommand instanceof Arguments) {
                            argsCmd = (Arguments)((Object)subCommand);
                            for (Argument argument : argsCmd.getArguments()) {
                                argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                                if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                                    argumentData.addChoices(Argument.toChoices(argument));
                                } else if (argument.argumentType == OptionType.INTEGER && argument.min != -1 && argument.max != -1) {
                                    argumentData.setRequiredRange((long)argument.min, (long)argument.max);
                                }
                                if (argument.completable) {
                                    argumentData.setAutoComplete(true);
                                }
                                cmdData = cmdData.addOptions(new OptionData[]{argumentData});
                            }
                        }
                        action = action.addSubcommands(new SubcommandData[]{cmdData});
                    } else {
                        Object options = new OptionData(OptionType.STRING, "action", "Execute another sub-command/action of this command.", false);
                        options = options.addChoice(subCommand.getLabel(), subCommand.getLabel());
                        if (subCommand instanceof Arguments) {
                            argsCmd = (Arguments)((Object)subCommand);
                            for (Argument argument : argsCmd.getArguments()) {
                                argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                                if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                                    argumentData.addChoices(Argument.toChoices(argument));
                                } else if (argument.argumentType == OptionType.INTEGER && argument.min != -1 && argument.max != -1) {
                                    argumentData.setRequiredRange((long)argument.min, (long)argument.max);
                                }
                                if (argument.completable) {
                                    argumentData.setAutoComplete(true);
                                }
                                action = action.addOptions(new OptionData[]{argumentData});
                            }
                        }
                        action = action.addOptions(new OptionData[]{options});
                    }
                    for (Alias alias : subCommand.getAliases()) {
                        CommandCreateAction subAction = guild == null ? this.jdaInstance.upsertCommand(alias.getLabel(), alias.getDescription()) : guild.upsertCommand(alias.getLabel(), alias.getDescription());
                        if (!(subCommand instanceof Arguments)) continue;
                        Arguments argsCmd = (Arguments)((Object)subCommand);
                        for (Argument argument : argsCmd.getArguments()) {
                            OptionData argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                            if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                                argumentData.addChoices(Argument.toChoices(argument));
                            } else if (argument.argumentType == OptionType.INTEGER && argument.min != -1 && argument.max != -1) {
                                argumentData.setRequiredRange((long)argument.min, (long)argument.max);
                            }
                            if (argument.completable) {
                                argumentData.setAutoComplete(true);
                            }
                            subAction = subAction.addOptions(new OptionData[]{argumentData});
                        }
                    }
                }
                if (command instanceof Arguments) {
                    Arguments argsCmd = (Arguments)((Object)command);
                    for (Argument argument : argsCmd.getArguments()) {
                        OptionData argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                        if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                            argumentData.addChoices(Argument.toChoices(argument));
                        } else if (argument.argumentType == OptionType.INTEGER && argument.min != -1 && argument.max != -1) {
                            argumentData.setRequiredRange((long)argument.min, (long)argument.max);
                        }
                        if (argument.completable) {
                            argumentData.setAutoComplete(true);
                        }
                        action = action.addOptions(new OptionData[]{argumentData});
                    }
                }
                commands.add(action);
            });
            if (guild == null) {
                this.jdaInstance.updateCommands().addCommands(commands).queue();
            } else {
                guild.updateCommands().addCommands(commands).queue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Deprecated
    public void deploy(@Nullable Guild guild) {
        if (guild == null) {
            this.jdaInstance.updateCommands().addCommands(new CommandData[0]).queue();
        } else {
            guild.updateCommands().addCommands(new CommandData[0]).queue();
        }
        this.commands.forEach((label, command) -> {
            CommandCreateAction action = guild == null ? this.jdaInstance.upsertCommand(label, command.getDescription()) : guild.upsertCommand(label, command.getDescription());
            for (SubCommand subCommand : ((Command)command).getSubCommands().values()) {
                if (command instanceof Baseless) {
                    SubcommandData cmdData = new SubcommandData(subCommand.getLabel(), subCommand.getDescription());
                    if (subCommand instanceof Arguments) {
                        for (Argument argument : ((Arguments)((Object)subCommand)).getArguments()) {
                            argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                            if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                                argumentData.addChoices(Argument.toChoices(argument));
                            }
                            if (argument.completable) {
                                argumentData.setAutoComplete(true);
                            }
                            cmdData = cmdData.addOptions(new OptionData[]{argumentData});
                        }
                    }
                    action = action.addSubcommands(new SubcommandData[]{cmdData});
                } else {
                    Object options = new OptionData(OptionType.STRING, "action", "Execute another sub-command/action of this command.", false);
                    options = options.addChoice(subCommand.getLabel(), subCommand.getLabel());
                    if (subCommand instanceof Arguments) {
                        for (Argument argument : ((Arguments)((Object)subCommand)).getArguments()) {
                            argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                            if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                                argumentData.addChoices(Argument.toChoices(argument));
                            }
                            if (argument.completable) {
                                argumentData.setAutoComplete(true);
                            }
                            action = action.addOptions(new OptionData[]{argumentData});
                        }
                    }
                    action = action.addOptions(new OptionData[]{options});
                }
                for (Alias alias : subCommand.getAliases()) {
                    CommandCreateAction subAction = guild == null ? this.jdaInstance.upsertCommand(alias.getLabel(), alias.getDescription()) : guild.upsertCommand(alias.getLabel(), alias.getDescription());
                    if (!(subCommand instanceof Arguments)) continue;
                    for (Argument argument : ((Arguments)((Object)subCommand)).getArguments()) {
                        OptionData argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                        if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                            argumentData.addChoices(Argument.toChoices(argument));
                        }
                        if (argument.completable) {
                            argumentData.setAutoComplete(true);
                        }
                        subAction = subAction.addOptions(new OptionData[]{argumentData});
                    }
                }
            }
            if (command instanceof Arguments) {
                for (Argument argument : ((Arguments)((Object)command)).getArguments()) {
                    OptionData argumentData = new OptionData(argument.argumentType, argument.label, argument.description, argument.required);
                    if (argument.choices != null && argument.argumentType == OptionType.STRING) {
                        argumentData.addChoices(Argument.toChoices(argument));
                    }
                    if (argument.completable) {
                        argumentData.setAutoComplete(true);
                    }
                    action = action.addOptions(new OptionData[]{argumentData});
                }
            }
            action.queue();
        });
    }
}

