/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import tech.xigam.cch.ComplexCommandHandler;
import tech.xigam.cch.command.Arguments;
import tech.xigam.cch.command.BaseCommand;
import tech.xigam.cch.utils.Argument;

public final class Interaction
implements Cloneable {
    private final boolean isSlash;
    private final boolean inGuild;
    private final BaseCommand command;
    private final ComplexCommandHandler commandHandler;
    private final Member member;
    private final Message message;
    private final MessageChannel channel;
    private final Guild guild;
    private SlashCommandInteractionEvent slashExecutor = null;
    private boolean ephemeral = false;
    private boolean sendToDMs = false;
    private boolean deferred = false;
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private final List<String> rawArguments = new ArrayList<String>();

    public Interaction(ComplexCommandHandler commandHandler, SlashCommandInteractionEvent event, BaseCommand command) {
        this.commandHandler = commandHandler;
        this.isSlash = true;
        this.inGuild = event.isFromGuild();
        this.slashExecutor = event;
        this.command = command;
        this.member = event.getMember();
        this.message = null;
        this.channel = event.getChannel();
        this.guild = event.getGuild();
        if (command instanceof Arguments) {
            Map<String, OptionType> argumentTypes = Argument.toOptions(((Arguments)((Object)command)).getArguments().toArray(new Argument[0]));
            for (Map.Entry<String, OptionType> entry : argumentTypes.entrySet()) {
                OptionMapping mapping = event.getOption(entry.getKey());
                if (mapping == null) continue;
                switch (entry.getValue()) {
                    case STRING: {
                        this.arguments.put(entry.getKey(), mapping.getAsString());
                        break;
                    }
                    case INTEGER: 
                    case NUMBER: {
                        this.arguments.put(entry.getKey(), mapping.getAsLong());
                        break;
                    }
                    case BOOLEAN: {
                        this.arguments.put(entry.getKey(), mapping.getAsBoolean());
                        break;
                    }
                    case MENTIONABLE: {
                        this.arguments.put(entry.getKey(), mapping.getAsMentionable());
                        break;
                    }
                    case USER: {
                        this.arguments.put(entry.getKey(), mapping.getAsUser());
                        break;
                    }
                    case ROLE: {
                        this.arguments.put(entry.getKey(), mapping.getAsRole());
                        break;
                    }
                    case CHANNEL: {
                        this.arguments.put(entry.getKey(), mapping.getAsMessageChannel());
                    }
                }
            }
        }
    }

    public Interaction(ComplexCommandHandler commandHandler, Message message, TextChannel channel, List<String> arguments, BaseCommand command) {
        this.commandHandler = commandHandler;
        this.isSlash = false;
        this.command = command;
        this.inGuild = message.isFromGuild();
        this.member = message.getMember();
        this.message = message;
        this.channel = channel;
        this.guild = channel.getGuild();
        if (command instanceof Arguments) {
            Argument[] args = ((Arguments)((Object)command)).getArguments().toArray(new Argument[0]);
            try {
                block6: for (int i = 0; i < arguments.size(); ++i) {
                    Argument argument = args[i];
                    if (argument.trailing) {
                        String combined = String.join((CharSequence)" ", arguments.subList(i, arguments.size()));
                        this.arguments.put(argument.reference, combined);
                        this.rawArguments.add(combined);
                        break;
                    }
                    switch (argument.argumentType) {
                        default: {
                            this.arguments.put(argument.reference, arguments.get(argument.position));
                            continue block6;
                        }
                        case INTEGER: {
                            this.arguments.put(argument.reference, Long.parseLong(arguments.get(argument.position)));
                            continue block6;
                        }
                        case BOOLEAN: {
                            this.arguments.put(argument.reference, Boolean.parseBoolean(arguments.get(argument.position)));
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.rawArguments.addAll(arguments);
    }

    public ComplexCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <T> T getArgument(String reference, Class<T> type) {
        return type.cast(this.arguments.get(reference));
    }

    public <T> T getArgument(String reference, T fallback, Class<T> type) {
        return type.cast(this.arguments.getOrDefault(reference, fallback));
    }

    public List<String> getRawArguments() {
        return this.rawArguments;
    }

    public Member getMember() {
        return this.member;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public Guild getGuild() {
        return this.guild;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    @Nullable
    public SlashCommandInteractionEvent getSlashExecutor() {
        return this.slashExecutor;
    }

    public boolean isSlash() {
        return this.isSlash;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public boolean isFromGuild() {
        return this.inGuild;
    }

    public void deferReply() {
        if (this.isSlash) {
            this.slashExecutor.deferReply(this.ephemeral).queue();
        } else {
            this.getChannel().sendTyping().queue();
        }
        this.deferred = true;
    }

    public Interaction setEphemeral() {
        this.ephemeral = true;
        return this;
    }

    public Interaction setEphemeral(boolean sendToDMs) {
        this.ephemeral = true;
        this.sendToDMs = sendToDMs;
        return this;
    }

    public Interaction sendMessage(String message) {
        this.getChannel().sendMessage((CharSequence)message).queue();
        return this;
    }

    public Interaction sendMessage(MessageEmbed message) {
        this.getChannel().sendMessageEmbeds(message, new MessageEmbed[0]).queue();
        return this;
    }

    public void reply(String message) {
        this.reply(message, true);
    }

    public void reply(MessageEmbed embed) {
        this.reply(embed, true);
    }

    public void reply(String message, boolean mentionUser) {
        if (this.isSlash()) {
            if (this.isDeferred()) {
                this.slashExecutor.getHook().sendMessage(message).queue();
            } else {
                this.slashExecutor.reply(message).setEphemeral(this.isEphemeral()).queue();
            }
        } else if (this.isEphemeral() && this.sendToDMs) {
            this.getMember().getUser().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage((CharSequence)message).queue());
        } else {
            this.getMessage().reply((CharSequence)message).mentionRepliedUser(mentionUser).queue();
        }
    }

    public void reply(MessageEmbed message, boolean mentionUser) {
        if (this.isSlash()) {
            if (this.isDeferred()) {
                this.slashExecutor.getHook().sendMessageEmbeds(message, new MessageEmbed[0]).queue();
            } else {
                this.slashExecutor.replyEmbeds(message, new MessageEmbed[0]).setEphemeral(this.isEphemeral()).queue();
            }
        } else if (this.isEphemeral() && this.sendToDMs) {
            this.getMember().getUser().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessageEmbeds(message, new MessageEmbed[0]).queue());
        } else {
            this.getMessage().replyEmbeds(message, new MessageEmbed[0]).mentionRepliedUser(mentionUser).queue();
        }
    }

    public void execute(final Consumer<Interaction> consumer, long after, TimeUnit timeUnit) {
        try {
            final Interaction messageClone = (Interaction)this.clone();
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    consumer.accept(messageClone);
                }
            }, timeUnit.toMillis(after));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }
}

