/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.defaults;

import java.util.Collection;
import java.util.List;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import tech.xigam.cch.command.Arguments;
import tech.xigam.cch.command.Command;
import tech.xigam.cch.utils.Argument;
import tech.xigam.cch.utils.Interaction;

public abstract class DeployCommand
extends Command
implements Arguments {
    public DeployCommand() {
        super("deploy", "Deploys all registered commands to your guild or globally.");
    }

    protected abstract boolean permissionCheck(Interaction var1);

    @Override
    public void execute(Interaction interaction) {
        if (!this.permissionCheck(interaction)) {
            interaction.reply("You don't have permission to deploy commands.");
            return;
        }
        Boolean global = interaction.getArgument("global", false, Boolean.class);
        Boolean delete = interaction.getArgument("delete", false, Boolean.class);
        if (!global.booleanValue() && !interaction.isFromGuild()) {
            global = true;
            interaction.sendMessage("You can't deploy slash commands to a DM, deploying globally instead.");
        }
        if (delete.booleanValue()) {
            interaction.getCommandHandler().downsert(global != false ? null : interaction.getGuild());
            interaction.reply("Deleted all commands.");
        } else {
            interaction.getCommandHandler().deployAll(global != false ? null : interaction.getGuild());
            interaction.reply("Deployed all commands.");
        }
    }

    @Override
    public Collection<Argument> getArguments() {
        return List.of(Argument.createWithChoices("global", "Should the commands be deployed globally?", "global", OptionType.BOOLEAN, true, 0, new String[0]), Argument.createWithChoices("delete", "Should commands be deleted instead of upserted?", "delete", OptionType.BOOLEAN, false, 1, new String[0]));
    }
}

