/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.cch.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import tech.xigam.cch.ComplexCommandHandler;
import tech.xigam.cch.command.Arguments;
import tech.xigam.cch.command.BaseCommand;
import tech.xigam.cch.command.Baseless;
import tech.xigam.cch.command.Completable;
import tech.xigam.cch.command.SubCommand;
import tech.xigam.cch.utils.Argument;
import tech.xigam.cch.utils.Completion;
import tech.xigam.cch.utils.Interaction;
import tech.xigam.cch.utils.InteractiveArguments;

public abstract class Command
implements BaseCommand {
    private final String label;
    private final String description;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();
    private List<String> interactiveArguments = new ArrayList<String>();

    public Command(String label, String description) {
        this.label = label;
        this.description = description;
    }

    public Command(String label, String description, String ... argumentQuestions) {
        this.label = label;
        this.description = description;
        this.interactiveArguments = List.of(argumentQuestions);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void prepareForExecution(List<String> arguments, Message message, Member sender, TextChannel channel, boolean skipArguments, ComplexCommandHandler handler) {
        ArrayList<String> args = new ArrayList<String>(arguments);
        boolean executeBase = true;
        for (String argument : arguments) {
            if (!this.subCommands.containsKey(argument)) continue;
            executeBase = false;
            args.remove(argument);
            this.getSubCommand(argument).prepareForExecution(args, message, sender, channel, false, handler);
        }
        if (executeBase) {
            if (this instanceof Arguments) {
                int requiredArguments = 0;
                for (Argument argument : ((Arguments)((Object)this)).getArguments()) {
                    if (!argument.required) continue;
                    ++requiredArguments;
                }
                if (args.size() < requiredArguments) {
                    handler.onArgumentError.accept(new Interaction(handler, message, channel, arguments, this));
                    return;
                }
            }
            if (this.interactiveArguments.size() == 0 || skipArguments) {
                this.execute(new Interaction(handler, message, channel, arguments, this));
            } else {
                new InteractiveArguments(message, sender, this, this.interactiveArguments, handler);
            }
        }
    }

    @Override
    public void prepareForExecution(SlashCommandInteractionEvent event, ComplexCommandHandler handler) {
        String subCommand = null;
        if (this instanceof Baseless) {
            subCommand = event.getSubcommandName();
        } else {
            OptionMapping option = event.getOption("action");
            if (option != null) {
                subCommand = option.getAsString();
            }
        }
        if (subCommand != null && this.subCommands.containsKey(subCommand)) {
            this.getSubCommand(subCommand).execute(new Interaction(handler, event, this.getSubCommand(subCommand)));
            return;
        }
        this.execute(new Interaction(handler, event, this));
    }

    @Override
    public void prepareForCompletion(CommandAutoCompleteInteractionEvent event, ComplexCommandHandler handler) {
        String subCommand = null;
        if (this instanceof Baseless) {
            subCommand = event.getSubcommandName();
        } else {
            OptionMapping option = event.getOption("action");
            if (option != null) {
                subCommand = option.getAsString();
            }
        }
        if (subCommand != null && this.subCommands.containsKey(subCommand)) {
            SubCommand subCmd = this.getSubCommand(subCommand);
            if (subCmd instanceof Completable) {
                ((Completable)((Object)subCmd)).complete(new Completion(event));
            }
            return;
        }
        if (this instanceof Completable) {
            ((Completable)((Object)this)).complete(new Completion(event));
        }
    }

    public final Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    protected final void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getLabel(), subCommand);
    }

    private SubCommand getSubCommand(String label) {
        return this.subCommands.get(label);
    }
}

