/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.basicqueuer;

import java.time.OffsetDateTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public final class BasicQueue {
    private final BlockingQueue<Consumer<OffsetDateTime>> queue = new LinkedBlockingQueue<Consumer<OffsetDateTime>>();
    private final long millisUntilAdvance;

    public BasicQueue(long msUntilNext) {
        this.millisUntilAdvance = msUntilNext;
    }

    public BasicQueue queueAction(Consumer<OffsetDateTime> action) {
        this.queue.add(action);
        return this;
    }

    public void next() {
        Consumer next = (Consumer)this.queue.poll();
        if (next != null) {
            next.accept(OffsetDateTime.now());
        }
    }

    public void start() {
        this.start(0L);
    }

    public void start(long initialDelay) {
        new Timer().scheduleAtFixedRate((TimerTask)new Next(this), initialDelay, this.millisUntilAdvance);
    }

    static class Next
    extends TimerTask {
        private final BasicQueue queue;

        public Next(BasicQueue queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            this.queue.next();
        }
    }
}

