/*
 * Decompiled with CFR 0.152.
 */
package tech.veedo.ragdoll.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import tech.veedo.ragdoll.exception.ExceptionAdviceEntity;
import tech.veedo.ragdoll.exception.GlobalException;
import tech.veedo.ragdoll.exception.GlobalExceptionCode;
import tech.veedo.ragdoll.exception.Mode;
import tech.veedo.ragdoll.utils.StringUtils;

@RestControllerAdvice
public class ExceptionControllerAdvice
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionControllerAdvice.class);
    private Boolean showRealErrorMessage;
    private String mode;

    @ExceptionHandler(value={GlobalException.class})
    @ResponseBody
    public ExceptionAdviceEntity globalExceptionHandler(GlobalException ex) {
        this.showError(ex);
        return this.generateResponseTMPWithData(ex.getErrorCode(), ex.getLocalizedMessage(), ex.getData());
    }

    @ExceptionHandler(value={ArithmeticException.class})
    @ResponseBody
    public ExceptionAdviceEntity arithmeticExceptionHandler(ArithmeticException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ARITHMETIC.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ARITHMETIC.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={ArrayIndexOutOfBoundsException.class})
    @ResponseBody
    public ExceptionAdviceEntity arrayIndexOutOfBoundsExceptionHandler(ArrayIndexOutOfBoundsException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ARRAY_INDEX_OUT_OF_BOUNDS.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ARRAY_INDEX_OUT_OF_BOUNDS.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={ArrayStoreException.class})
    @ResponseBody
    public ExceptionAdviceEntity arrayStoreExceptionHandler(ArrayStoreException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ARRAY_STORE.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ARRAY_STORE.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={ClassCastException.class})
    @ResponseBody
    public ExceptionAdviceEntity classCastExceptionHandler(ClassCastException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.CLASS_CAST.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.CLASS_CAST.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={ClassNotFoundException.class})
    @ResponseBody
    public ExceptionAdviceEntity classNotFoundExceptionHandler(ClassNotFoundException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.CLASS_NOT_FOUND.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.CLASS_NOT_FOUND.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={CloneNotSupportedException.class})
    @ResponseBody
    public ExceptionAdviceEntity cloneNotSupportedExceptionHandler(CloneNotSupportedException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.CLONE_NOT_SUPPORTED.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.CLONE_NOT_SUPPORTED.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={EnumConstantNotPresentException.class})
    @ResponseBody
    public ExceptionAdviceEntity enumConstantNotPresentExceptionHandler(EnumConstantNotPresentException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ENUM_CONSTANT_NOT_PRESENT.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ENUM_CONSTANT_NOT_PRESENT.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={IllegalAccessException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalAccessExceptionHandler(IllegalAccessException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_ACCESS.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ILLEGAL_ACCESS.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalArgumentExceptionHandler(IllegalArgumentException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_ARGUMENT.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ILLEGAL_ARGUMENT.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={IllegalMonitorStateException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalMonitorStateExceptionHandler(IllegalMonitorStateException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_MONITOR.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ILLEGAL_MONITOR.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalStateExceptionHandler(IllegalStateException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_STATE.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ILLEGAL_STATE.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={IllegalThreadStateException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalThreadStateExceptionHandler(IllegalThreadStateException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_THREAD_STATE.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.ILLEGAL_THREAD_STATE.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseBody
    public ExceptionAdviceEntity indexOutOfBoundsExceptionHandler(IndexOutOfBoundsException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.INDEX_OUT_OF_BOUNDS.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.INDEX_OUT_OF_BOUNDS.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={InstantiationException.class})
    @ResponseBody
    public ExceptionAdviceEntity instantiationExceptionHandler(InstantiationException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.INSTANTIATION.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.INSTANTIATION.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={InterruptedException.class})
    @ResponseBody
    public ExceptionAdviceEntity interruptedExceptionHandler(InterruptedException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.INTERRUPTED.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.INTERRUPTED.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={NegativeArraySizeException.class})
    @ResponseBody
    public ExceptionAdviceEntity negativeArraySizeExceptionHandler(NegativeArraySizeException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NEGATIVE_ARRAY_SIZE.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.NEGATIVE_ARRAY_SIZE.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={NoSuchFieldException.class})
    @ResponseBody
    public ExceptionAdviceEntity noSuchFieldExceptionHandler(NoSuchFieldException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NO_SUCH_FIELD.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.NO_SUCH_FIELD.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={NoSuchMethodException.class})
    @ResponseBody
    public ExceptionAdviceEntity noSuchMethodExceptionHandler(NoSuchMethodException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NO_SUCH_METHOD.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.NO_SUCH_METHOD.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public ExceptionAdviceEntity nullPointerExceptionHandler(NullPointerException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NULL_POINTER.getErrorCode(), ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={NumberFormatException.class})
    @ResponseBody
    public ExceptionAdviceEntity numberFormatExceptionHandler(NumberFormatException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NUMBER_FORMAT.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.NUMBER_FORMAT.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={ReflectiveOperationException.class})
    @ResponseBody
    public ExceptionAdviceEntity reflectiveOperationExceptionHandler(ReflectiveOperationException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.REFLECTIVE_OPERATION.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.REFLECTIVE_OPERATION.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ExceptionAdviceEntity runtimeExceptionHandler(RuntimeException ex) {
        if (this.showRealErrorMessage.booleanValue()) {
            this.showError(ex);
            return this.generateResponseTMP(GlobalExceptionCode.RUNTIME.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.RUNTIME.getMessage() : ex.getLocalizedMessage());
        }
        ex.printStackTrace();
        return this.generateResponseTMP(GlobalExceptionCode.UNEXPECTED.getErrorCode(), GlobalExceptionCode.UNEXPECTED.getMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseBody
    public ExceptionAdviceEntity securityExceptionHandler(SecurityException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.SECURITY.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.SECURITY.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={StringIndexOutOfBoundsException.class})
    @ResponseBody
    public ExceptionAdviceEntity stringIndexOutOfBoundsExceptionHandler(StringIndexOutOfBoundsException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.STRING_INDEX_OUT_OF_BOUNDS.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.STRING_INDEX_OUT_OF_BOUNDS.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={TypeNotPresentException.class})
    @ResponseBody
    public ExceptionAdviceEntity typeNotPresentExceptionHandler(TypeNotPresentException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.TYPE_NOT_PRESENT.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.TYPE_NOT_PRESENT.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    public ExceptionAdviceEntity unsupportedOperationExceptionHandler(UnsupportedOperationException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.UNSUPPORTED_OPERATION.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.UNSUPPORTED_OPERATION.getMessage() : ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ExceptionAdviceEntity exceptionHandler(Throwable ex) {
        if (this.showRealErrorMessage.booleanValue()) {
            this.showError(ex);
            return this.generateResponseTMP(GlobalExceptionCode.UNEXPECTED.getErrorCode(), StringUtils.isBlank(ex.getLocalizedMessage()) ? GlobalExceptionCode.UNEXPECTED.getMessage() : ex.getLocalizedMessage());
        }
        ex.printStackTrace();
        return this.generateResponseTMP(GlobalExceptionCode.UNEXPECTED.getErrorCode(), GlobalExceptionCode.UNEXPECTED.getMessage());
    }

    private ExceptionAdviceEntity generateResponseTMP(Integer code, String msg) {
        return new ExceptionAdviceEntity().setStatusCode(code).setMessage(msg);
    }

    private ExceptionAdviceEntity generateResponseTMPWithData(Integer code, String msg, Object data) {
        return new ExceptionAdviceEntity().setStatusCode(code).setMessage(msg).setData(data);
    }

    private void showError(Throwable e) {
        if (Mode.getMode(this.mode) == Mode.STACK) {
            e.printStackTrace();
        } else {
            log.error(e.getMessage());
        }
    }

    public Boolean getShowRealErrorMessage() {
        return this.showRealErrorMessage;
    }

    public void setShowRealErrorMessage(Boolean showRealErrorMessage) {
        this.showRealErrorMessage = showRealErrorMessage;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

