/*
 * Decompiled with CFR 0.152.
 */
package tech.veedo.ragdoll.globaladvice;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Member;
import java.util.Arrays;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import tech.veedo.ragdoll.exception.ExceptionAdviceEntity;
import tech.veedo.ragdoll.globaladvice.GlobalAdviceEntity;

@RestControllerAdvice
public class GlobalControllerAdvice
implements ResponseBodyAdvice {
    private String[] ignoreMethods;
    private String[] basePackages;

    public GlobalControllerAdvice(String[] ignoreMethods) {
        this.ignoreMethods = ignoreMethods;
    }

    public boolean supports(MethodParameter returnType, Class converterType) {
        Member m = returnType.getMember();
        if (this.basePackages != null && this.basePackages.length > 0) {
            String classPath = m.getDeclaringClass().getPackage().getName();
            return Arrays.stream(this.basePackages).anyMatch(basePackage -> basePackage.equals(classPath)) ? this.ignore(m) : false;
        }
        return this.ignore(m);
    }

    private boolean ignore(Member m) {
        if (this.ignoreMethods != null && this.ignoreMethods.length > 0) {
            String methodName = m.getName();
            return !Arrays.stream(this.ignoreMethods).anyMatch(ignoreMethod -> ignoreMethod.equals(methodName));
        }
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (!(body instanceof GlobalAdviceEntity) && !(body instanceof ExceptionAdviceEntity)) {
            if (body == null) {
                return new GlobalAdviceEntity();
            }
            if (body instanceof String) {
                return JSON.toJSONString((Object)new GlobalAdviceEntity().setData(body));
            }
            if (body instanceof Boolean) {
                return new GlobalAdviceEntity().setSuccess((Boolean)body);
            }
            return new GlobalAdviceEntity().setData(body);
        }
        return body;
    }

    public String[] getIgnoreMethods() {
        return this.ignoreMethods;
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public void setIgnoreMethods(String[] ignoreMethods) {
        this.ignoreMethods = ignoreMethods;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalControllerAdvice)) {
            return false;
        }
        GlobalControllerAdvice other = (GlobalControllerAdvice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIgnoreMethods(), other.getIgnoreMethods())) {
            return false;
        }
        return Arrays.deepEquals(this.getBasePackages(), other.getBasePackages());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalControllerAdvice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getIgnoreMethods());
        result = result * 59 + Arrays.deepHashCode(this.getBasePackages());
        return result;
    }

    public String toString() {
        return "GlobalControllerAdvice(ignoreMethods=" + Arrays.deepToString(this.getIgnoreMethods()) + ", basePackages=" + Arrays.deepToString(this.getBasePackages()) + ")";
    }
}

