/*
 * Decompiled with CFR 0.152.
 */
package tech.veedo.ragdoll.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import tech.veedo.ragdoll.exception.ExceptionAdviceEntity;
import tech.veedo.ragdoll.exception.GlobalException;
import tech.veedo.ragdoll.exception.GlobalExceptionCode;
import tech.veedo.ragdoll.exception.Mode;
import tech.veedo.ragdoll.utils.StringUtils;

@RestControllerAdvice
public class ExceptionControllerAdvice
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionControllerAdvice.class);
    private String mode;

    @ExceptionHandler(value={GlobalException.class})
    @ResponseBody
    public ExceptionAdviceEntity globalExceptionHanlder(GlobalException ex) {
        this.showError(ex);
        return this.generateResponseTMPWithData(ex.getErrorCode(), ex.getMessage(), ex.getData());
    }

    @ExceptionHandler(value={ArithmeticException.class})
    @ResponseBody
    public ExceptionAdviceEntity arithmeticExceptionHanlder(ArithmeticException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ARITHMETIC.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ARITHMETIC.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={ArrayIndexOutOfBoundsException.class})
    @ResponseBody
    public ExceptionAdviceEntity arrayIndexOutOfBoundsExceptionHanlder(ArrayIndexOutOfBoundsException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ARRAY_INDEX_OUT_OF_BOUNDS.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ARRAY_INDEX_OUT_OF_BOUNDS.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={ArrayStoreException.class})
    @ResponseBody
    public ExceptionAdviceEntity arrayStoreExceptionHanlder(ArrayStoreException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ARRAY_STORE.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ARRAY_STORE.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={ClassCastException.class})
    @ResponseBody
    public ExceptionAdviceEntity classCastExceptionHanlder(ClassCastException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.CLASS_CAST.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.CLASS_CAST.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={ClassNotFoundException.class})
    @ResponseBody
    public ExceptionAdviceEntity classNotFoundExceptionHanlder(ClassNotFoundException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.CLASS_NOT_FOUND.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.CLASS_NOT_FOUND.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={CloneNotSupportedException.class})
    @ResponseBody
    public ExceptionAdviceEntity cloneNotSupportedExceptionHanlder(CloneNotSupportedException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.CLONE_NOT_SUPPORTED.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.CLONE_NOT_SUPPORTED.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={EnumConstantNotPresentException.class})
    @ResponseBody
    public ExceptionAdviceEntity enumConstantNotPresentExceptionHanlder(EnumConstantNotPresentException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ENUM_CONSTANT_NOT_PRESENT.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ENUM_CONSTANT_NOT_PRESENT.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={IllegalAccessException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalAccessExceptionHanlder(IllegalAccessException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_ACCESS.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ILLEGAL_ACCESS.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalArgumentExceptionHanlder(IllegalArgumentException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_ARGUMENT.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ILLEGAL_ARGUMENT.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={IllegalMonitorStateException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalMonitorStateExceptionHanlder(IllegalMonitorStateException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_MONITOR.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ILLEGAL_MONITOR.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalStateExceptionHanlder(IllegalStateException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_STATE.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ILLEGAL_STATE.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={IllegalThreadStateException.class})
    @ResponseBody
    public ExceptionAdviceEntity illegalThreadStateExceptionHanlder(IllegalThreadStateException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.ILLEGAL_THREAD_STATE.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.ILLEGAL_THREAD_STATE.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseBody
    public ExceptionAdviceEntity indexOutOfBoundsExceptionHanlder(IndexOutOfBoundsException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.INDEX_OUT_OF_BOUNDS.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.INDEX_OUT_OF_BOUNDS.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={InstantiationException.class})
    @ResponseBody
    public ExceptionAdviceEntity instantiationExceptionHanlder(InstantiationException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.INSTANTIATION.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.INSTANTIATION.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={InterruptedException.class})
    @ResponseBody
    public ExceptionAdviceEntity interruptedExceptionHanlder(InterruptedException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.INTERRUPTED.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.INTERRUPTED.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={NegativeArraySizeException.class})
    @ResponseBody
    public ExceptionAdviceEntity negativeArraySizeExceptionHanlder(NegativeArraySizeException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NEGATIVE_ARRAY_SIZE.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.NEGATIVE_ARRAY_SIZE.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={NoSuchFieldException.class})
    @ResponseBody
    public ExceptionAdviceEntity noSuchFieldExceptionnHanlder(NoSuchFieldException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NO_SUCH_FIELD.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.NO_SUCH_FIELD.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={NoSuchMethodException.class})
    @ResponseBody
    public ExceptionAdviceEntity noSuchMethodExceptionHanlder(NoSuchMethodException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NO_SUCH_METHOD.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.NO_SUCH_METHOD.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public ExceptionAdviceEntity nullPointerExceptionHanlder(NullPointerException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NULL_POINTER.getErrorCode(), ex.getMessage());
    }

    @ExceptionHandler(value={NumberFormatException.class})
    @ResponseBody
    public ExceptionAdviceEntity numberFormatExceptionHanlder(NumberFormatException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.NUMBER_FORMAT.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.NUMBER_FORMAT.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={ReflectiveOperationException.class})
    @ResponseBody
    public ExceptionAdviceEntity reflectiveOperationExceptionHanlder(ReflectiveOperationException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.REFLECTIVE_OPERATION.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.REFLECTIVE_OPERATION.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ExceptionAdviceEntity runtimeExceptionHanlder(RuntimeException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.RUNTIME.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.RUNTIME.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseBody
    public ExceptionAdviceEntity securityExceptionHanlder(SecurityException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.SECURITY.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.SECURITY.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={StringIndexOutOfBoundsException.class})
    @ResponseBody
    public ExceptionAdviceEntity stringIndexOutOfBoundsExceptionHanlder(StringIndexOutOfBoundsException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.STRING_INDEX_OUT_OF_BOUNDS.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.STRING_INDEX_OUT_OF_BOUNDS.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={TypeNotPresentException.class})
    @ResponseBody
    public ExceptionAdviceEntity typeNotPresentExceptionHanlder(TypeNotPresentException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.TYPE_NOT_PRESENT.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.TYPE_NOT_PRESENT.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    public ExceptionAdviceEntity unsupportedOperationExceptionHanlder(UnsupportedOperationException ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.UNSUPPORTED_OPERATION.getErrorCode(), StringUtils.isBlank(ex.getMessage()) ? GlobalExceptionCode.UNSUPPORTED_OPERATION.getMessage() : ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ExceptionAdviceEntity exceptionHanlder(Throwable ex) {
        this.showError(ex);
        return this.generateResponseTMP(GlobalExceptionCode.COMMON.getErrorCode(), ex.getMessage());
    }

    private ExceptionAdviceEntity generateResponseTMP(Integer code, String msg) {
        return new ExceptionAdviceEntity().setStatusCode(code).setMessage(msg);
    }

    private ExceptionAdviceEntity generateResponseTMPWithData(Integer code, String msg, Object data) {
        return new ExceptionAdviceEntity().setStatusCode(code).setMessage(msg).setData(data);
    }

    private void showError(Throwable e) {
        switch (Mode.getMode(this.mode)) {
            case STACK: {
                e.printStackTrace();
                break;
            }
            default: {
                log.error(e.getMessage());
            }
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

