/*
 * Decompiled with CFR 0.152.
 */
package tech.veedo.ragdoll;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.veedo.ragdoll.RagdollProperties;
import tech.veedo.ragdoll.exception.ExceptionControllerAdvice;
import tech.veedo.ragdoll.globaladvice.GlobalControllerAdvice;
import tech.veedo.ragdoll.utils.StringUtils;

@Configuration
@EnableConfigurationProperties(value={RagdollProperties.class})
public class RagdollAutoConfiguration {
    @Autowired
    private RagdollProperties ragdollProperties;

    @Bean
    @ConditionalOnMissingBean(value={GlobalControllerAdvice.class})
    @ConditionalOnProperty(prefix="veedo.ragdoll.global-advice", name={"enabled"}, havingValue="true")
    public GlobalControllerAdvice generateCommonControllerAdvice() {
        String basePackages;
        String str = this.ragdollProperties.getGlobalAdvice().getIgnoreMethods();
        GlobalControllerAdvice advice = new GlobalControllerAdvice(null);
        if (StringUtils.isNotBlank(str)) {
            advice.setIgnoreMethods(str.split(","));
        }
        if (StringUtils.isNotBlank(basePackages = this.ragdollProperties.getGlobalAdvice().getBasePackages())) {
            advice.setBasePackages(basePackages.split(","));
        }
        return advice;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionControllerAdvice.class})
    @ConditionalOnProperty(prefix="veedo.ragdoll.exception-advice", name={"enabled"}, havingValue="true")
    public ExceptionControllerAdvice generateExceptionControllerAdvice() {
        ExceptionControllerAdvice advice = new ExceptionControllerAdvice();
        String mode = this.ragdollProperties.getExceptionAdvice().getMode();
        if (StringUtils.isBlank(mode)) {
            throw new NullPointerException("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\u6253\u5370\u5f02\u5e38\u6a21\u5f0f\uff08mode\uff09\u4e3a\u7a7a");
        }
        if (!mode.toLowerCase().equals("log") && !mode.toLowerCase().equals("stack")) {
            throw new IllegalArgumentException("\u7edf\u4e00\u5f02\u5e38\u5904\u7406\u6253\u5370\u5f02\u5e38\u6a21\u5f0f\uff08mode\uff09\u7684\u503c\u8303\u56f4\uff1a[log, stack]");
        }
        advice.setMode(mode);
        return advice;
    }
}

