/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.tools.obix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.MeasurementException;
import javax.measure.Prefix;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import tech.uom.lib.common.function.DescriptionSupplier;
import tech.uom.tools.obix.LocalHelpers;

final class ObixUnit
implements Unit,
DescriptionSupplier {
    private static final String DEFAULT_PATH = "src/main/resources/etc/units.txt";
    private static final List<ObixUnit> list = new ArrayList<ObixUnit>();
    private static final HashMap byId = new HashMap();
    private static final Map<Dimension, Dimension> dims = new HashMap<Dimension, Dimension>();
    private static final Map quantities = new HashMap();
    private static final HashMap combos = new HashMap();
    private static final List<String> quantityNames;
    private static final Dim dimensionless;
    private final List ids;
    private final double scale;
    private final double offset;
    private final Dim dim;

    public static ObixUnit parse(String name) {
        return ObixUnit.parse(name, true);
    }

    public static ObixUnit parse(String name, boolean checked) {
        HashMap hashMap = byId;
        synchronized (hashMap) {
            ObixUnit unit = (ObixUnit)byId.get(name);
            if (unit != null || !checked) {
                return unit;
            }
            throw new MeasurementException("Unit not found: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Unit> units() {
        List<ObixUnit> list = ObixUnit.list;
        synchronized (list) {
            return Collections.unmodifiableList(LocalHelpers.dup(ObixUnit.list.toArray(), ObixUnit.list.size()));
        }
    }

    public static List<String> quantityNames() {
        return quantityNames;
    }

    public static Map quantities() {
        return quantities;
    }

    public static List quantity(String quantity) {
        List list = (List)quantities.get(quantity);
        if (list == null) {
            throw new MeasurementException("Unknown unit database quantity: " + quantity);
        }
        return list;
    }

    private static List<String> loadDatabase() {
        BufferedReader in = null;
        ArrayList<String> quantityNames = new ArrayList<String>();
        try {
            String line;
            String path = DEFAULT_PATH;
            FileReader fr = new FileReader(path);
            in = new LineNumberReader(fr);
            String curQuantityName = null;
            ArrayList<ObixUnit> curQuantityList = null;
            while ((line = ((LineNumberReader)in).readLine()) != null) {
                if ((line = line.trim()).startsWith("//") || line.length() == 0) continue;
                if (line.startsWith("--")) {
                    if (curQuantityName != null) {
                        quantities.put(curQuantityName, Collections.unmodifiableList(curQuantityList));
                    }
                    curQuantityName = line.substring(2, line.indexOf(40)).trim();
                    curQuantityList = new ArrayList<ObixUnit>();
                    quantityNames.add(curQuantityName);
                    continue;
                }
                try {
                    ObixUnit unit = ObixUnit.define(line);
                    curQuantityList.add(unit);
                }
                catch (Exception e) {
                    System.err.println("WARNING: Init unit in src/main/resources/etc/units.txt: " + line);
                    System.err.println("  " + e);
                }
            }
            quantities.put(curQuantityName, Collections.unmodifiableList(curQuantityList));
        }
        catch (Throwable e) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("WARNING: Cannot load src/main/resources/etc/units.txt");
            e.printStackTrace();
        }
        return Collections.unmodifiableList(quantityNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObixUnit define(String str) {
        ObixUnit unit = null;
        try {
            unit = ObixUnit.parseUnit(str);
        }
        catch (Throwable e) {
            String msg = str;
            if (e instanceof MeasurementParseException) {
                msg = msg + ": " + ((MeasurementParseException)e).getMessage();
            }
            throw new MeasurementException("Unit", e);
        }
        HashMap hashMap = byId;
        synchronized (hashMap) {
            String id;
            int i;
            for (i = 0; i < unit.ids.size(); ++i) {
                id = (String)unit.ids.get(i);
                if (byId.get(id) == null) continue;
                throw new MeasurementException("Unit id already defined: " + id);
            }
            for (i = 0; i < unit.ids.size(); ++i) {
                id = (String)unit.ids.get(i);
                byId.put(id, unit);
            }
            list.add(unit);
        }
        return unit;
    }

    private static ObixUnit parseUnit(String s) {
        String idStrs = s;
        int c = s.indexOf(59);
        if (c > 0) {
            idStrs = s.substring(0, c);
        }
        List ids = LocalHelpers.split(idStrs, 44L);
        if (c < 0) {
            return new ObixUnit(ids, dimensionless, 1.0, 0.0);
        }
        String dim = s = s.substring(c + 1).trim();
        c = s.indexOf(59);
        if (c < 0) {
            return new ObixUnit(ids, ObixUnit.parseDim(dim), 1.0, 0.0);
        }
        dim = s.substring(0, c).trim();
        String scale = s = s.substring(c + 1).trim();
        c = s.indexOf(59);
        if (c < 0) {
            return new ObixUnit(ids, ObixUnit.parseDim(dim), Double.parseDouble(scale), 0.0);
        }
        scale = s.substring(0, c).trim();
        String offset = s.substring(c + 1).trim();
        return new ObixUnit(ids, ObixUnit.parseDim(dim), Double.parseDouble(scale), Double.parseDouble(offset));
    }

    private static Dim parseDim(String s) {
        if (s.length() == 0) {
            return dimensionless;
        }
        Dim dim = new Dim();
        List ratios = LocalHelpers.split(s, 42L, true);
        for (int i = 0; i < ratios.size(); ++i) {
            String r = (String)ratios.get(i);
            if (r.startsWith("kg")) {
                dim.kg = Byte.parseByte(r.substring(2).trim());
                continue;
            }
            if (r.startsWith("sec")) {
                dim.sec = Byte.parseByte(r.substring(3).trim());
                continue;
            }
            if (r.startsWith("mol")) {
                dim.mol = Byte.parseByte(r.substring(3).trim());
                continue;
            }
            if (r.startsWith("m")) {
                dim.m = Byte.parseByte(r.substring(1).trim());
                continue;
            }
            if (r.startsWith("K")) {
                dim.K = Byte.parseByte(r.substring(1).trim());
                continue;
            }
            if (r.startsWith("A")) {
                dim.A = Byte.parseByte(r.substring(1).trim());
                continue;
            }
            if (r.startsWith("cd")) {
                dim.cd = Byte.parseByte(r.substring(2).trim());
                continue;
            }
            throw new MeasurementException("Bad ratio '" + r + "'");
        }
        return dim.intern();
    }

    private ObixUnit(List<String> ids, Dim dim, double scale, double offset) {
        this.ids = ObixUnit.checkIds(ids);
        this.dim = dim;
        this.scale = scale;
        this.offset = offset;
    }

    static List checkIds(List ids) {
        if (ids.size() == 0) {
            throw new MeasurementException("No unit ids defined");
        }
        for (int i = 0; i < ids.size(); ++i) {
            ObixUnit.checkId((String)ids.get(i));
        }
        return Collections.unmodifiableList(ids);
    }

    static void checkId(String id) {
        if (id.length() == 0) {
            throw new MeasurementException("Invalid unit id length 0");
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isAlphabetic(c) || c == '_' || c == '%' || c == '/' || c == '$' || c > '\u0080') continue;
            throw new MeasurementException("Invalid unit id " + id + " (invalid char '" + (char)c + "')");
        }
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final long hash() {
        return Objects.hashCode(this.toString());
    }

    final Class typeof() {
        return ObixUnit.class;
    }

    public final String toString() {
        return (String)this.ids.get(this.ids.size() - 1);
    }

    public final List ids() {
        return this.ids;
    }

    public final String getName() {
        return (String)this.ids.get(0);
    }

    public final String getSymbol() {
        return (String)this.ids.get(this.ids.size() - 1);
    }

    public final double scale() {
        return this.scale;
    }

    public final double offset() {
        return this.offset;
    }

    public final String getDescription() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.ids.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.ids.get(i));
        }
        if (this.dim != dimensionless) {
            s.append("; ").append(this.dim);
            if (this.scale != 1.0 || this.offset != 0.0) {
                s.append("; ").append(this.scale);
                if (this.offset != 0.0) {
                    s.append("; ").append(this.offset);
                }
            }
        }
        return s.toString();
    }

    public final long kg() {
        return this.dim.kg;
    }

    public final long m() {
        return this.dim.m;
    }

    public final long sec() {
        return this.dim.sec;
    }

    public final long K() {
        return this.dim.K;
    }

    public final long A() {
        return this.dim.A;
    }

    public final long mol() {
        return this.dim.mol;
    }

    public final long cd() {
        return this.dim.cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Unit multiply(Unit b) {
        HashMap hashMap = combos;
        synchronized (hashMap) {
            Combo key = new Combo(this, "*", b);
            ObixUnit r = (ObixUnit)combos.get(key);
            if (r == null) {
                r = ObixUnit.findMult(this, b);
                combos.put(key, r);
            }
            return r;
        }
    }

    private static Unit findMult(Unit x, Unit y) {
        if (x instanceof ObixUnit && y instanceof ObixUnit) {
            double scale;
            ObixUnit a = (ObixUnit)x;
            ObixUnit b = (ObixUnit)y;
            if (a.dim.isDimensionless() || b.dim.isDimensionless()) {
                throw new MeasurementException("Cannot compute dimensionless: " + a + " * " + b);
            }
            Dim dim = a.dim.add(b.dim).intern();
            ObixUnit[] matches = ObixUnit.match(dim, scale = a.scale * b.scale);
            if (matches.length == 1) {
                return matches[0];
            }
            String expectedName = a.getName() + "_" + b.getName();
            for (int i = 0; i < matches.length; ++i) {
                if (!matches[i].getName().equals(expectedName)) continue;
                return matches[i];
            }
            throw new MeasurementException("Cannot match to db: " + a + " * " + b);
        }
        throw new IllegalArgumentException("Cannot match: " + x.getClass() + " / " + y.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Unit divide(Unit b) {
        HashMap hashMap = combos;
        synchronized (hashMap) {
            Combo key = new Combo(this, "/", b);
            ObixUnit r = (ObixUnit)combos.get(key);
            if (r == null) {
                r = this.findDiv(this, b);
                combos.put(key, r);
            }
            return r;
        }
    }

    final Unit findDiv(Unit x, Unit y) {
        if (x instanceof ObixUnit && y instanceof ObixUnit) {
            double scale;
            ObixUnit a = (ObixUnit)x;
            ObixUnit b = (ObixUnit)y;
            if (a.dim.isDimensionless() || b.dim.isDimensionless()) {
                throw new MeasurementException("Cannot compute dimensionless: " + a + " / " + b);
            }
            Dim dim = a.dim.subtract(b.dim).intern();
            ObixUnit[] matches = ObixUnit.match(dim, scale = a.scale / b.scale);
            if (matches.length == 1) {
                return matches[0];
            }
            String expectedName = a.getName() + "_per_" + b.getName();
            for (int i = 0; i < matches.length; ++i) {
                if (!matches[i].getName().contains(expectedName)) continue;
                return matches[i];
            }
            throw new MeasurementException("Cannot match to db: " + a + " / " + b);
        }
        throw new IllegalArgumentException("Cannot match: " + x.getClass() + " / " + y.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObixUnit[] match(Dim dim, double scale) {
        ArrayList<ObixUnit> acc = new ArrayList<ObixUnit>();
        List<ObixUnit> list = ObixUnit.list;
        synchronized (list) {
            for (int i = 0; i < ObixUnit.list.size(); ++i) {
                ObixUnit x = ObixUnit.list.get(i);
                if (x.dim != dim || !ObixUnit.approx(x.scale, scale)) continue;
                acc.add(x);
            }
        }
        return acc.toArray(new ObixUnit[acc.size()]);
    }

    private static boolean approx(double a, double b) {
        if (a == b) {
            return true;
        }
        double t = Math.min(Math.abs(a / 1000.0), Math.abs(b / 1000.0));
        return Math.abs(a - b) <= t;
    }

    public final double convertTo(double scalar, ObixUnit to) {
        if (this.dim != to.dim) {
            throw new MeasurementException("Incovertable units: " + this + " and " + to);
        }
        return (scalar * this.scale + this.offset - to.offset) / to.scale;
    }

    public Dimension getDimension() {
        return this.dim;
    }

    public Unit alternate(String arg0) {
        return null;
    }

    public Unit asType(Class arg0) throws ClassCastException {
        return null;
    }

    public Unit divide(double arg0) {
        return null;
    }

    public UnitConverter getConverterTo(Unit arg0) throws UnconvertibleException {
        return null;
    }

    public UnitConverter getConverterToAny(Unit arg0) throws IncommensurableException, UnconvertibleException {
        return null;
    }

    public Map getProductUnits() {
        return null;
    }

    public Unit getSystemUnit() {
        return null;
    }

    public Unit inverse() {
        return null;
    }

    public boolean isCompatible(Unit arg0) {
        return false;
    }

    public Unit multiply(double arg0) {
        return null;
    }

    public Unit pow(int arg0) {
        return null;
    }

    public Unit root(int arg0) {
        return null;
    }

    public Unit shift(double arg0) {
        return null;
    }

    public Unit transform(UnitConverter arg0) {
        return null;
    }

    public Map getBaseUnits() {
        return null;
    }

    public Unit shift(Number offset) {
        return null;
    }

    public Unit multiply(Number multiplier) {
        return null;
    }

    public Unit divide(Number divisor) {
        return null;
    }

    public Unit prefix(Prefix prefix) {
        return null;
    }

    public boolean isEquivalentTo(Unit that) {
        return false;
    }

    static {
        dimensionless = new Dim();
        dims.put(dimensionless, dimensionless);
        quantityNames = ObixUnit.loadDatabase();
    }

    static final class Dim
    implements Dimension {
        String str;
        byte kg;
        byte m;
        byte sec;
        byte K;
        byte A;
        byte mol;
        byte cd;

        Dim() {
        }

        public int hashCode() {
            return this.kg << 28 ^ this.m << 23 ^ this.sec << 18 ^ this.K << 13 ^ this.A << 8 ^ this.mol << 3 ^ this.cd;
        }

        public boolean equals(Object o) {
            Dim x = (Dim)o;
            return this.kg == x.kg && this.m == x.m && this.sec == x.sec && this.K == x.K && this.A == x.A && this.mol == x.mol && this.cd == x.cd;
        }

        public String toString() {
            if (this.str == null) {
                StringBuilder s = new StringBuilder();
                this.append(s, "kg", this.kg);
                this.append(s, "m", this.m);
                this.append(s, "sec", this.sec);
                this.append(s, "K", this.K);
                this.append(s, "A", this.A);
                this.append(s, "mol", this.mol);
                this.append(s, "cd", this.cd);
                this.str = s.toString();
            }
            return this.str;
        }

        private void append(StringBuilder s, String key, int val) {
            if (val == 0) {
                return;
            }
            if (s.length() > 0) {
                s.append('*');
            }
            s.append(key).append(val);
        }

        public Dim add(Dim b) {
            Dim r = new Dim();
            r.kg = (byte)(this.kg + b.kg);
            r.m = (byte)(this.m + b.m);
            r.sec = (byte)(this.sec + b.sec);
            r.K = (byte)(this.K + b.K);
            r.A = (byte)(this.A + b.A);
            r.mol = (byte)(this.mol + b.mol);
            r.cd = (byte)(this.cd + b.cd);
            return r;
        }

        public Dim subtract(Dim b) {
            Dim r = new Dim();
            r.kg = (byte)(this.kg - b.kg);
            r.m = (byte)(this.m - b.m);
            r.sec = (byte)(this.sec - b.sec);
            r.K = (byte)(this.K - b.K);
            r.A = (byte)(this.A - b.A);
            r.mol = (byte)(this.mol - b.mol);
            r.cd = (byte)(this.cd - b.cd);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dim intern() {
            Map map = dims;
            synchronized (map) {
                Dim cached = (Dim)dims.get(this);
                if (cached != null) {
                    return cached;
                }
                dims.put(this, this);
                return this;
            }
        }

        public boolean isDimensionless() {
            return this.toString().length() == 0;
        }

        public Dimension divide(Dimension arg0) {
            return null;
        }

        public Map<? extends Dimension, Integer> getProductDimensions() {
            return null;
        }

        public Dimension multiply(Dimension arg0) {
            return null;
        }

        public Dimension pow(int arg0) {
            return null;
        }

        public Dimension root(int arg0) {
            return null;
        }

        public Map<? extends Dimension, Integer> getBaseDimensions() {
            return null;
        }
    }

    static final class Combo {
        final Unit a;
        final String op;
        final Unit b;

        Combo(Unit a, String op, Unit b) {
            this.a = a;
            this.op = op;
            this.b = b;
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.op.hashCode() ^ this.b.hashCode() << 13;
        }

        public boolean equals(Object that) {
            Combo x = (Combo)that;
            return this.a == x.a && this.op == x.op && this.b == x.b;
        }
    }
}

