/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.tools.obix;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.help.Help;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.measure.Unit;
import javax.tools.Tool;
import tech.uom.lib.common.function.DescriptionSupplier;
import tech.uom.tools.obix.ObixUnit;

public class ObixImporter
implements Tool {
    protected static final Logger logger = Logger.getLogger(ObixImporter.class.getName());

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        try {
            CliBuilder builder = Cli.builder((String)this.getClass().getSimpleName()).withDescription("oBIX Importer Tool").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Write.class});
            Cli toolParser = builder.build();
            ((Runnable)toolParser.parse(arguments)).run();
            return ErrorCode.OK.ordinal();
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            return ErrorCode.Failure.ordinal();
        }
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(new HashSet<SourceVersion>(Arrays.asList(SourceVersion.RELEASE_5, SourceVersion.RELEASE_6, SourceVersion.RELEASE_7)));
    }

    public static void main(String[] args) {
        ObixImporter importer = new ObixImporter();
        int errorCode = importer.run(System.in, System.out, System.err, args);
        if (errorCode == ErrorCode.OK.ordinal()) {
            System.out.println("Success.");
        } else {
            System.err.println("Error!");
        }
    }

    @Command(name="write", description="Write to file")
    public static final class Write
    extends ToolCommand {
        @Option(name={"-q"}, description="Quantities output file")
        public String quantOutFile;
        @Arguments(description="Quantities to write")
        public List<String> quantities;

        @Override
        public void run() {
            if (this.quantOutFile != null && this.quantOutFile.length() > 0) {
                logger.info(this.getClass().getSimpleName() + " to " + this.quantOutFile);
            } else {
                logger.info(this.getClass().getSimpleName());
            }
            if (this.quantities != null) {
                for (String string : this.quantities) {
                    System.out.println(string);
                }
            }
            if (this.verbose) {
                List<Unit> units = ObixUnit.units();
                if (units != null && units.size() > 0) {
                    for (Unit u : units) {
                        logger.fine("Unit: " + u + ", " + u.getName() + ",  " + u.getDimension() + " :: " + ((DescriptionSupplier)u).getDescription());
                    }
                }
                Map map = ObixUnit.quantities();
                for (Object key : map.keySet()) {
                    logger.fine("Key: " + key + "; Value: " + map.get(key));
                }
                for (String q : ObixUnit.quantityNames()) {
                    logger.fine("Quantity: " + q);
                }
            }
            if (this.quantOutFile != null && this.quantOutFile.length() > 0) {
                this.writeToFile(ObixUnit.quantityNames(), this.quantOutFile);
            }
        }

        private void writeToFile(List<String> quantities, String fileName) {
            try (FileWriter fw = new FileWriter(fileName);
                 BufferedWriter bw = new BufferedWriter(fw);){
                for (String q : quantities) {
                    bw.write(q);
                    bw.newLine();
                }
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
        }
    }

    static enum ErrorCode {
        OK,
        Failure;

    }

    static class ToolCommand
    implements Runnable {
        @Option(type=OptionType.GLOBAL, name={"-v"}, description="Verbose mode")
        public boolean verbose;

        ToolCommand() {
        }

        @Override
        public void run() {
            System.out.println(this.getClass().getSimpleName());
        }
    }
}

