/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.tools.obix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class LocalHelpers {
    LocalHelpers() {
    }

    static final List dup(Object[] values, int size) {
        Object[] dup = new Object[size];
        System.arraycopy(values, 0, dup, 0, size);
        return Arrays.asList(dup);
    }

    public static List split(String self) {
        return LocalHelpers.split(self, null, true);
    }

    public static List split(String self, Long separator) {
        return LocalHelpers.split(self, separator, true);
    }

    public static List split(String self, Long separator, boolean trimmed) {
        if (separator == null) {
            return LocalHelpers.splitws(self);
        }
        int sep = separator.intValue();
        boolean trim = trimmed;
        ArrayList<String> toks = new ArrayList<String>(16);
        int len = self.length();
        int x = 0;
        for (int i = 0; i < len; ++i) {
            if (self.charAt(i) != sep) continue;
            if (x <= i) {
                toks.add(LocalHelpers.splitStr(self, x, i, trim));
            }
            x = i + 1;
        }
        if (x <= len) {
            toks.add(LocalHelpers.splitStr(self, x, len, trim));
        }
        return toks;
    }

    private static String splitStr(String val, int s, int e, boolean trim) {
        if (trim) {
            while (s < e && val.charAt(s) <= ' ') {
                ++s;
            }
            while (e > s && val.charAt(e - 1) <= ' ') {
                --e;
            }
        }
        return val.substring(s, e);
    }

    public static List splitws(String val) {
        int x;
        int len;
        ArrayList<String> toks = new ArrayList<String>(16);
        for (len = val.length(); len > 0 && val.charAt(len - 1) <= ' '; --len) {
        }
        for (x = 0; x < len && val.charAt(x) <= ' '; ++x) {
        }
        for (int i = x; i < len; ++i) {
            if (val.charAt(i) > ' ') continue;
            toks.add(val.substring(x, i));
            for (x = i + 1; x < len && val.charAt(x) <= ' '; ++x) {
            }
            i = x;
        }
        if (x <= len) {
            toks.add(val.substring(x, len));
        }
        if (toks.size() == 0) {
            toks.add("");
        }
        return toks;
    }

    public static List splitLines(String self) {
        ArrayList<String> lines = new ArrayList<String>(16);
        int len = self.length();
        int s = 0;
        for (int i = 0; i < len; ++i) {
            char c = self.charAt(i);
            if (c != '\n' && c != '\r') continue;
            lines.add(self.substring(s, i));
            s = i + 1;
            if (c != '\r' || s >= len || self.charAt(s) != '\n') continue;
            ++i;
            ++s;
        }
        lines.add(self.substring(s, len));
        return lines;
    }
}

