/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.tools.cldr;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.measure.format.MeasurementParseException;
import tech.uom.lib.common.function.Parser;

final class CLDRParser
implements Parser<Object, String> {
    private static final Logger logger = Logger.getLogger(CLDRParser.class.getName());
    private final boolean verbose;
    private final Set<String> unitSet = new HashSet<String>();
    private final Set<String> quantitySet = new HashSet<String>();

    public static void main(String[] args) throws Exception {
        CLDRParser parsing = new CLDRParser(true);
        parsing.load("/root/units.json");
    }

    CLDRParser(boolean v) {
        this.verbose = v;
    }

    void load(String ... files) throws IOException, MeasurementParseException {
        if (files != null && files.length > 0) {
            InputStream is = CLDRParser.class.getResourceAsStream(files[0]);
            JsonReader rdr = Json.createReader((InputStream)is);
            JsonObject obj = rdr.readObject();
            JsonObject main = obj.getJsonObject("main");
            JsonObject root = main.getJsonObject("root");
            JsonObject units = root.getJsonObject("units");
            JsonObject longUnits = units.getJsonObject("long");
            Set entries = longUnits.entrySet();
            for (Object o : entries) {
                this.handle(this.parse(o));
            }
            if (this.unitSet.size() > 0 && files.length > 1) {
                this.writeToFile(this.unitSet, files[1]);
            }
            if (this.quantitySet.size() > 0 && files.length > 2) {
                this.writeToFile(this.quantitySet, files[2]);
            }
        }
    }

    public String parse(Object input) throws MeasurementParseException {
        return String.valueOf(input);
    }

    private void handle(String st) {
        String[] subStrings = st.split("=");
        if (subStrings != null && subStrings.length > 0) {
            this.handleUnit(subStrings[0]);
        }
    }

    private void handleUnit(String unitEntry) {
        if (unitEntry.contains("-")) {
            int quantCutOff = unitEntry.indexOf("-");
            String quantity = unitEntry.substring(0, quantCutOff);
            this.quantitySet.add(quantity);
            String unit = unitEntry.substring(quantCutOff + 1);
            this.unitSet.add(quantity + ";" + unit);
            if (this.verbose) {
                System.out.println(quantity + ": " + unit);
            }
        } else {
            logger.warning(String.format("'%s' has no quantity, ignoring.", unitEntry));
        }
    }

    private void writeToFile(Set<String> strings, String fileName) {
        if (fileName != null && fileName.length() > 0) {
            try (FileWriter fw = new FileWriter(fileName);
                 BufferedWriter bw = new BufferedWriter(fw);){
                for (String s : strings) {
                    bw.write(s);
                    bw.newLine();
                }
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
        }
    }
}

