/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.tools.cldr;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.help.Help;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.measure.format.MeasurementParseException;
import javax.tools.Tool;
import tech.uom.tools.cldr.CLDRParser;

public class CLDRImporter
implements Tool {
    private static final Logger logger = Logger.getLogger(CLDRImporter.class.getName());
    static boolean isVerbose;

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        try {
            CliBuilder builder = Cli.builder((String)this.getClass().getSimpleName()).withDescription("Unicode CLDR Importer Tool").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Display.class}).withCommands(Help.class, new Class[]{Write.class});
            Cli toolParser = builder.build();
            ((Runnable)toolParser.parse(arguments)).run();
            return ErrorCode.OK.ordinal();
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            return ErrorCode.Failure.ordinal();
        }
    }

    @Override
    public final Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(new HashSet<SourceVersion>(Arrays.asList(SourceVersion.RELEASE_5, SourceVersion.RELEASE_6, SourceVersion.RELEASE_7)));
    }

    public static void main(String[] args) throws Exception {
        CLDRImporter importer = new CLDRImporter();
        int errorCode = importer.run(System.in, System.out, System.err, args);
        if (errorCode == ErrorCode.OK.ordinal() && isVerbose) {
            System.out.println("Success.");
        }
    }

    @Command(name="display", description="Display elements")
    public static final class Display
    extends ToolCommand {
        @Option(name={"-i"}, description="Input file")
        public String inFile;

        @Override
        public void run() {
            if (this.inFile != null && this.inFile.length() > 0) {
                logger.info(this.getClass().getSimpleName() + " " + this.inFile);
            } else {
                logger.info(this.getClass().getSimpleName());
            }
            isVerbose = this.verbose;
            if (this.inFile != null && this.inFile.length() > 0) {
                try {
                    CLDRParser parser = new CLDRParser(true);
                    parser.load(this.inFile);
                }
                catch (MeasurementParseException pe) {
                    logger.log(Level.WARNING, this.getClass().getSimpleName() + " error", pe);
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, this.getClass().getSimpleName() + " loading error", ioe);
                }
            }
        }
    }

    @Command(name="write", description="Write to file")
    public static final class Write
    extends ToolCommand {
        @Option(name={"-i"}, description="Input file")
        public String inFile;
        @Option(name={"-u"}, description="Units output file (CSV)")
        public String unitOutFile;
        @Option(name={"-q"}, description="Quantities output file")
        public String quantOutFile;
        @Option(name={"-s"}, description="Sort entries")
        public boolean sorted;
        @Arguments(description="Quantities to write (Filter)")
        public List<String> quantityFilter;

        @Override
        public void run() {
            StringBuilder message = new StringBuilder(this.getClass().getSimpleName());
            if (this.unitOutFile != null && this.unitOutFile.length() > 0 || this.quantOutFile != null && this.quantOutFile.length() > 0) {
                message.append(" to ");
                if (this.unitOutFile != null && this.unitOutFile.length() > 0) {
                    message.append(this.unitOutFile);
                    if (this.quantOutFile != null && this.quantOutFile.length() > 0) {
                        message.append(", ");
                        message.append(this.quantOutFile);
                    }
                } else if (this.quantOutFile != null && this.quantOutFile.length() > 0) {
                    message.append(this.quantOutFile);
                }
            }
            logger.info(message.toString());
            isVerbose = this.verbose;
            if (this.inFile != null && this.inFile.length() > 0 && (this.unitOutFile != null && this.unitOutFile.length() > 0 || this.quantOutFile != null && this.quantOutFile.length() > 0)) {
                try {
                    CLDRParser parser = new CLDRParser(this.verbose);
                    parser.load(this.inFile, this.unitOutFile, this.quantOutFile);
                }
                catch (MeasurementParseException pe) {
                    logger.log(Level.WARNING, this.getClass().getSimpleName() + " error", pe);
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, this.getClass().getSimpleName() + " loading error", ioe);
                }
            }
        }
    }

    static enum ErrorCode {
        OK,
        Failure;

    }

    static class ToolCommand
    implements Runnable {
        @Option(type=OptionType.GLOBAL, name={"-v"}, description="Verbose mode")
        public boolean verbose;

        ToolCommand() {
        }

        @Override
        public void run() {
            System.out.println(this.getClass().getSimpleName());
        }
    }
}

