/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tech.uom.seshat.util.WeakEntry;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private Entry[] table;
    private int count;
    private final Class<K> keyType;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient long lastTimeNormalCapacity;

    public WeakValueHashMap(Class<K> clazz) {
        this.keyType = clazz;
        this.lastTimeNormalCapacity = System.nanoTime();
        Entry[] entryArray = (Entry[])Array.newInstance(Entry.class, 7);
        this.table = entryArray;
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.isValid());
        int n = this.table.length;
        if (entry.removeFrom(this.table, entry.hash % n)) {
            long l;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(n) && (l = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count);
                this.lastTimeNormalCapacity = l;
                assert (this.isValid());
            }
        }
    }

    final boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public synchronized V get(Object object) {
        assert (this.isValid());
        if (object != null) {
            Entry[] entryArray = this.table;
            int n = (object.hashCode() & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.key)) {
                    return (V)entry.get();
                }
                entry = (Entry)entry.next;
            }
        }
        return null;
    }

    private synchronized V intern(Object object, V v, boolean bl) {
        assert (this.isValid());
        V v2 = null;
        Entry[] entryArray = this.table;
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (object.equals(entry.key)) {
                v2 = (V)entry.get();
                if (v2 != null && !bl) {
                    return v2;
                }
                entry.dispose();
                entryArray = this.table;
                n2 = n % entryArray.length;
            }
            entry = (Entry)entry.next;
        }
        if (v != null) {
            if (++this.count >= WeakEntry.lowerCapacityThreshold(entryArray.length)) {
                if (this.count > WeakEntry.upperCapacityThreshold(entryArray.length)) {
                    this.table = entryArray = (Entry[])WeakEntry.rehash(entryArray, this.count);
                    n2 = n % entryArray.length;
                }
                this.lastTimeNormalCapacity = System.nanoTime();
            }
            entryArray[n2] = new Entry(this.keyType.cast(object), v, entryArray[n2], n);
        }
        assert (this.isValid());
        return v2;
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return this.intern(k, v, true);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return this.intern(k, v, false);
    }

    @Override
    public V remove(Object object) {
        return this.intern(object, null, true);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class Entry
    extends WeakEntry<V>
    implements Map.Entry<K, V> {
        final K key;

        Entry(K k, V v, Entry entry, int n) {
            super(v, entry, n);
            this.key = k;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V v) {
            if (v != null) {
                throw new UnsupportedOperationException();
            }
            Object t = this.get();
            this.dispose();
            return t;
        }

        @Override
        public void dispose() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key.equals(entry.getKey()) && Objects.equals(this.get(), entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = this.key.hashCode();
            Object t = this.get();
            if (t != null) {
                n ^= t.hashCode();
            }
            return n;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<K, V>[] toArray() {
            WeakValueHashMap weakValueHashMap = WeakValueHashMap.this;
            synchronized (weakValueHashMap) {
                Entry[] entryArray;
                assert (WeakValueHashMap.this.isValid());
                Map.Entry[] entryArray2 = new Map.Entry[this.size()];
                int n = 0;
                for (Entry entry : entryArray = WeakValueHashMap.this.table) {
                    while (entry != null) {
                        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(entry);
                        if (simpleEntry.getValue() != null) {
                            entryArray2[n++] = simpleEntry;
                        }
                        entry = (Entry)entry.next;
                    }
                }
                if (n != entryArray2.length) {
                    entryArray2 = Arrays.copyOf(entryArray2, n);
                }
                return entryArray2;
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Arrays.asList(this.toArray()).iterator();
        }
    }
}

